/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp;

import java.net.Socket;
import java.net.SocketTimeoutException;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.retry.RetryContext;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.tcp.TcpConnector;
import org.mule.transport.tcp.TcpMessageDispatcher;

public class TcpMessageRequester
extends AbstractMessageRequester {
    private final TcpConnector connector;

    public TcpMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (TcpConnector)endpoint.getConnector();
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        if (timeout > Integer.MAX_VALUE || timeout < 0L) {
            throw new IllegalArgumentException("Timeout incorrect: " + timeout);
        }
        Socket socket = this.connector.getSocket(this.endpoint);
        try {
            Object result = TcpMessageDispatcher.receiveFromSocket(socket, (int)timeout, this.endpoint);
            if (result == null) {
                return null;
            }
            return new DefaultMuleMessage(this.connector.getMessageAdapter(result), this.connector.getMuleContext());
        }
        catch (SocketTimeoutException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Socket timed out normally while doing a synchronous receive on endpointUri: " + this.endpoint.getEndpointURI()));
            }
            return null;
        }
    }

    protected synchronized void doDispose() {
        try {
            this.doDisconnect();
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to shutdown the dispatcher.", (Throwable)e);
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryContext validateConnection(RetryContext retryContext) {
        Socket socket = null;
        try {
            socket = this.connector.getSocket(this.endpoint);
            retryContext.setOk();
        }
        catch (Exception ex) {
            retryContext.setFailed(ex);
        }
        finally {
            block13: {
                if (socket != null) {
                    try {
                        this.connector.releaseSocket(socket, this.endpoint);
                    }
                    catch (Exception e) {
                        if (!this.logger.isDebugEnabled()) break block13;
                        this.logger.debug((Object)("Failed to release a socket " + socket), (Throwable)e);
                    }
                }
            }
        }
        return retryContext;
    }
}

