/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.activation.MimeType;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.transport.email.MailMessageAdapter;
import org.mule.transport.email.MailUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

public class SimpleMailMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = 8002607243523460556L;
    public static final String HEADER_LIST_PREFIX = "List:";
    private Part message;
    private byte[] cache = null;

    public SimpleMailMessageAdapter(Object object) throws MuleException {
        Message message = SimpleMailMessageAdapter.assertMessageType(object);
        try {
            this.setMessageDetails(message);
            this.handleMessage(message);
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.failedToCreate((String)"Message Adapter"), (Throwable)e);
        }
    }

    protected SimpleMailMessageAdapter(SimpleMailMessageAdapter template) {
        super((MessageAdapter)template);
        this.message = template.message;
        this.cache = template.cache;
    }

    protected void handleMessage(Message message) throws Exception {
        this.setMessage((Part)message);
    }

    protected void setMessage(Part message) {
        this.message = message;
    }

    public Object getPayload() {
        return this.message;
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return this.buildCache(this.getEncoding());
    }

    public String getPayloadAsString(String encoding) throws Exception {
        return new String(this.buildCache(encoding), encoding);
    }

    private byte[] buildCache(String encoding) throws Exception {
        if (null == this.cache) {
            this.cache = this.message.getContentType().startsWith("text/") ? this.textPayload(encoding) : this.binaryPayload();
        }
        return this.cache;
    }

    private static Message assertMessageType(Object message) throws MessageTypeNotSupportedException {
        if (message instanceof Message) {
            return (Message)message;
        }
        throw new MessageTypeNotSupportedException(message, MailMessageAdapter.class);
    }

    private void setMessageDetails(Message message) throws MessagingException {
        this.setProperty("inbound.toAddresses", MailUtils.mailAddressesToString(message.getRecipients(Message.RecipientType.TO)));
        this.setProperty("inbound.ccAddresses", MailUtils.mailAddressesToString(message.getRecipients(Message.RecipientType.CC)));
        this.setProperty("inbound.bccAddresses", MailUtils.mailAddressesToString(message.getRecipients(Message.RecipientType.BCC)));
        try {
            this.setProperty("inbound.replyToAddresses", MailUtils.mailAddressesToString(message.getReplyTo()));
        }
        catch (MessagingException me) {
            logger.warn((Object)"Invalid address found in ReplyTo header:", (Throwable)me);
        }
        try {
            this.setProperty("inbound.fromAddress", MailUtils.mailAddressesToString(message.getFrom()));
        }
        catch (MessagingException me) {
            logger.warn((Object)"Invalid address found in From header:", (Throwable)me);
        }
        this.setProperty("inbound.subject", StringUtils.defaultIfEmpty((String)message.getSubject(), (String)"(no subject)"));
        this.setProperty("inbound.contentType", StringUtils.defaultIfEmpty((String)message.getContentType(), (String)"text/plain"));
        Date sentDate = message.getSentDate();
        if (sentDate == null) {
            sentDate = new Date();
        }
        this.setProperty("sentDate", sentDate);
        Enumeration e = message.getAllHeaders();
        while (e.hasMoreElements()) {
            Header header = (Header)e.nextElement();
            String name = header.getName();
            String listName = SimpleMailMessageAdapter.toListHeader(name);
            String value = header.getValue();
            if (null == this.getProperty(name)) {
                this.setProperty(name, value);
            }
            if (null == this.getProperty(listName)) {
                this.setProperty(listName, new LinkedList());
            }
            if (!(this.getProperty(listName) instanceof List)) continue;
            ((List)this.getProperty(listName)).add(header.getValue());
        }
    }

    public static boolean isListHeader(String name) {
        return null != name && name.startsWith(HEADER_LIST_PREFIX);
    }

    public static String toHeader(String name) {
        if (SimpleMailMessageAdapter.isListHeader(name)) {
            return name.substring(HEADER_LIST_PREFIX.length());
        }
        return name;
    }

    public static String toListHeader(String header) {
        if (SimpleMailMessageAdapter.isListHeader(header)) {
            return header;
        }
        return HEADER_LIST_PREFIX + header;
    }

    private static InputStream addBuffer(InputStream stream) {
        if (!(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        return stream;
    }

    private byte[] binaryPayload() throws Exception {
        InputStream stream = SimpleMailMessageAdapter.addBuffer(this.message.getInputStream());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
        IOUtils.copy((InputStream)stream, (OutputStream)baos);
        return baos.toByteArray();
    }

    private byte[] textPayload(String encoding) throws Exception {
        String line;
        InputStream stream = SimpleMailMessageAdapter.addBuffer(this.message.getInputStream());
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, this.getMessageCharset()));
        StringBuffer buffer = new StringBuffer(32768);
        while ((line = reader.readLine()) != null) {
            buffer.append(line).append(SystemUtils.LINE_SEPARATOR);
        }
        return buffer.toString().getBytes(encoding);
    }

    public ThreadSafeAccess newThreadCopy() {
        return new SimpleMailMessageAdapter(this);
    }

    private String getMessageCharset() {
        try {
            String ct = this.message.getDataHandler().getContentType();
            MimeType mt = new MimeType(ct);
            return mt.getParameter("charset");
        }
        catch (Exception e) {
            String charset = System.getProperty("file.encoding");
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Unable to read charset from message. Defaulting to the system default: " + charset), (Throwable)e);
            }
            return charset;
        }
    }
}

