/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.net.URLDecoder;
import java.util.Calendar;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.email.MailUtils;
import org.mule.transport.email.SmtpConnector;

public class SmtpMessageDispatcher
extends AbstractMessageDispatcher {
    private volatile Transport transport;

    public SmtpMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    private SmtpConnector castConnector() {
        return (SmtpConnector)this.getConnector();
    }

    protected void doConnect() throws Exception {
        if (this.transport == null) {
            try {
                this.transport = this.castConnector().getSessionDetails(this.endpoint).newTransport();
                EndpointURI uri = this.endpoint.getEndpointURI();
                String encoding = this.endpoint.getEncoding();
                String user = uri.getUser() != null ? URLDecoder.decode(uri.getUser(), encoding) : null;
                String pass = uri.getPassword() != null ? URLDecoder.decode(uri.getPassword(), encoding) : null;
                this.transport.connect(uri.getHost(), uri.getPort(), user, pass);
            }
            catch (Exception e) {
                throw new EndpointException(MessageFactory.createStaticMessage((String)"Unable to connect to mail transport."), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() throws Exception {
        if (null != this.transport) {
            try {
                this.transport.close();
            }
            finally {
                this.transport = null;
            }
        }
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        Object data = event.transformMessage();
        if (!(data instanceof Message)) {
            throw new DispatchException(CoreMessages.transformUnexpectedType(data.getClass(), Message.class), event.getMessage(), event.getEndpoint());
        }
        this.sendMailMessage((Message)data);
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        return new DefaultMuleMessage((Object)NullPayload.getInstance(), this.connector.getMuleContext());
    }

    protected void sendMailMessage(Message message) throws MessagingException {
        message.setSentDate(Calendar.getInstance().getTime());
        if (!this.transport.isConnected()) {
            EndpointURI uri = this.endpoint.getEndpointURI();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Connection closed by remote server. Reconnecting.");
            }
            this.transport.connect(uri.getHost(), uri.getPort(), uri.getUser(), uri.getPassword());
        }
        this.transport.sendMessage(message, message.getAllRecipients());
        if (this.logger.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg.append("Email message sent with subject'").append(message.getSubject()).append("' sent- ");
            msg.append(", From: ").append(MailUtils.mailAddressesToString(message.getFrom())).append(" ");
            msg.append(", To: ").append(MailUtils.mailAddressesToString(message.getRecipients(Message.RecipientType.TO))).append(" ");
            msg.append(", Cc: ").append(MailUtils.mailAddressesToString(message.getRecipients(Message.RecipientType.CC))).append(" ");
            msg.append(", Bcc: ").append(MailUtils.mailAddressesToString(message.getRecipients(Message.RecipientType.BCC))).append(" ");
            msg.append(", ReplyTo: ").append(MailUtils.mailAddressesToString(message.getReplyTo()));
            this.logger.debug((Object)msg.toString());
        }
    }

    protected void doDispose() {
    }
}

