/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HeaderGroup;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.StatusLine;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.transport.NullPayload;

public class HttpResponse {
    public static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    private HttpVersion ver = HttpVersion.HTTP_1_1;
    private int statusCode = 200;
    private String phrase = HttpStatus.getStatusText((int)200);
    private HeaderGroup headers = new HeaderGroup();
    private boolean keepAlive = false;
    private boolean disableKeepAlive = false;
    private String fallbackCharset = "ISO-8859-1";
    private OutputHandler outputHandler;

    public HttpResponse() {
    }

    public HttpResponse(StatusLine statusline, Header[] headers, InputStream content) throws IOException {
        if (statusline == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        this.setStatusLine(HttpVersion.parse((String)statusline.getHttpVersion()), statusline.getStatusCode(), statusline.getReasonPhrase());
        this.setHeaders(headers);
        if (content != null) {
            long len;
            InputStream in = content;
            Header contentLength = this.headers.getFirstHeader("Content-Length");
            Header transferEncoding = this.headers.getFirstHeader("Transfer-Encoding");
            if (transferEncoding != null) {
                if (transferEncoding.getValue().indexOf("chunked") != -1) {
                    in = new ChunkedInputStream(in);
                }
            } else if (contentLength != null && (len = this.getContentLength()) >= 0L) {
                in = new ContentLengthInputStream(in, len);
            }
        }
    }

    public void setStatusLine(HttpVersion ver, int statuscode, String phrase) {
        if (ver == null) {
            throw new IllegalArgumentException("HTTP version may not be null");
        }
        if (statuscode <= 0) {
            throw new IllegalArgumentException("Status code may not be negative or zero");
        }
        this.ver = ver;
        this.statusCode = statuscode;
        this.phrase = phrase != null ? phrase : HttpStatus.getStatusText((int)statuscode);
    }

    public void setStatusLine(HttpVersion ver, int statuscode) {
        this.setStatusLine(ver, statuscode, null);
    }

    public String getPhrase() {
        return this.phrase;
    }

    public int getStatuscode() {
        return this.getStatusCode();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public HttpVersion getHttpVersion() {
        return this.ver;
    }

    public String getStatusLine() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(this.ver);
        buffer.append(' ');
        buffer.append(this.statusCode);
        if (this.phrase != null) {
            buffer.append(' ');
            buffer.append(this.phrase);
        }
        return buffer.toString();
    }

    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    public Header[] getHeaders() {
        return this.headers.getAllHeaders();
    }

    public Header getFirstHeader(String name) {
        return this.headers.getFirstHeader(name);
    }

    public void removeHeaders(String s) {
        if (s == null) {
            return;
        }
        Header[] headers = this.headers.getHeaders(s);
        for (int i = 0; i < headers.length; ++i) {
            this.headers.removeHeader(headers[i]);
        }
    }

    public void addHeader(Header header) {
        if (header == null) {
            return;
        }
        this.headers.addHeader(header);
    }

    public void setHeader(Header header) {
        if (header == null) {
            return;
        }
        this.removeHeaders(header.getName());
        this.addHeader(header);
    }

    public void setHeaders(Header[] headers) {
        if (headers == null) {
            return;
        }
        this.headers.setHeaders(headers);
    }

    public Iterator getHeaderIterator() {
        return this.headers.getIterator();
    }

    public String getCharset() {
        NameValuePair param;
        HeaderElement[] values;
        String charset = this.getFallbackCharset();
        Header contenttype = this.headers.getFirstHeader("Content-Type");
        if (contenttype != null && (values = contenttype.getElements()).length == 1 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        return charset;
    }

    public long getContentLength() {
        Header contentLength = this.headers.getFirstHeader("Content-Length");
        if (contentLength != null) {
            try {
                return Long.parseLong(contentLength.getValue());
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }

    public boolean hasBody() {
        return this.outputHandler != null;
    }

    public OutputHandler getBody() throws TransformerException {
        return this.outputHandler;
    }

    public void setBody(MuleMessage msg) throws TransformerException {
        if (msg == null) {
            return;
        }
        Object payload = msg.getPayload();
        if (payload instanceof String) {
            this.setBody(payload.toString());
        } else {
            if (payload instanceof NullPayload) {
                return;
            }
            if (payload instanceof byte[]) {
                this.setBody((byte[])payload);
            } else {
                this.setBody((OutputHandler)msg.getPayload(OutputHandler.class));
            }
        }
    }

    public void setBody(OutputHandler outputHandler) {
        this.outputHandler = outputHandler;
    }

    public void setBody(String string) {
        byte[] raw;
        try {
            raw = string.getBytes(this.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            raw = string.getBytes();
        }
        this.setBody(raw);
    }

    private void setBody(final byte[] raw) {
        if (!this.containsHeader("Content-Type")) {
            this.setHeader(new Header("Content-Type", "text/plain"));
        }
        if (!this.containsHeader("Transfer-Encoding")) {
            this.setHeader(new Header("Content-Length", Long.toString(raw.length)));
        }
        this.outputHandler = new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                out.write(raw);
            }
        };
    }

    public String getBodyAsString() throws IOException {
        if (!this.hasBody()) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outputHandler.write(RequestContext.getEvent(), (OutputStream)out);
        try {
            return new String(out.toByteArray(), this.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            return new String(out.toByteArray());
        }
    }

    public boolean isKeepAlive() {
        return !this.disableKeepAlive && this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    protected void setupKeepAliveFromRequestVersion(HttpVersion version) {
        this.setKeepAlive(version.equals(HttpVersion.HTTP_1_1));
    }

    public void disableKeepAlive(boolean keepalive) {
        this.disableKeepAlive = keepalive;
    }

    public String getFallbackCharset() {
        return this.fallbackCharset;
    }

    public void setFallbackCharset(String overrideCharset) {
        this.fallbackCharset = overrideCharset;
    }
}

