/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

public abstract class Job
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss,SSS");
    long id;
    int version;
    Date dueDate;
    ProcessInstance processInstance;
    Token token;
    TaskInstance taskInstance;
    boolean isSuspended;
    boolean isExclusive;
    String lockOwner;
    Date lockTime;
    String exception;
    int retries = 1;
    String configuration;

    public Job() {
    }

    public Job(Token token) {
        this.token = token;
        this.processInstance = token.getProcessInstance();
    }

    public abstract boolean execute(JbpmContext var1) throws Exception;

    public String toString() {
        return "job[" + this.id + "]";
    }

    public String toStringLongFormat() {
        return "id=" + this.id + ", version=" + this.version + ", dueDate=" + (this.dueDate != null ? dateFormat.format(this.dueDate) : null) + ", isSuspended=" + this.isSuspended + ", isExclusive=" + this.isExclusive + ", lockOwner=" + this.lockOwner + ", lockTime=" + this.lockTime + ", exception=" + this.exception + ", retries=" + this.retries + ", configuration=" + this.configuration;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public long getId() {
        return this.id;
    }

    public Date getAqcuireDate() {
        return this.lockTime;
    }

    public void setLockTime(Date aqcuireDate) {
        this.lockTime = aqcuireDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    public String getJobExecutorName() {
        return this.lockOwner;
    }

    public void setLockOwner(String jobExecutorName) {
        this.lockOwner = jobExecutorName;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    public void setTaskInstance(TaskInstance taskInstance) {
        this.taskInstance = taskInstance;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public Date getLockTime() {
        return this.lockTime;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setSuspended(boolean isSuspended) {
        this.isSuspended = isSuspended;
    }

    public int getVersion() {
        return this.version;
    }
}

