/*
 * $Id: Invocation.java 12558 2008-08-25 19:09:19Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.api.interceptor;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.service.Service;

/**
 * <code>Invocation</code> represents a link in an interceptor chain.
 */
public interface Invocation
{

    /**
     * Invokes the next interceptor or target
     */
    MuleMessage invoke() throws MuleException;

    Service getService();

    MuleEvent getEvent();

    MuleMessage getMessage();

    void setMessage(MuleMessage message);

}
