/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ELUtil;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanELResolver
extends ELResolver {
    private boolean isReadOnly;
    private static final int CACHE_SIZE = 1024;
    private static final ConcurrentHashMap<Class, BeanProperties> properties = new ConcurrentHashMap(1024);

    public BeanELResolver() {
        this.isReadOnly = false;
    }

    public BeanELResolver(boolean bl) {
        this.isReadOnly = bl;
    }

    @Override
    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (object == null || object2 == null) {
            return null;
        }
        BeanProperty beanProperty = this.getBeanProperty(eLContext, object, object2);
        eLContext.setPropertyResolved(true);
        return beanProperty.getPropertyType();
    }

    @Override
    public Object getValue(ELContext eLContext, Object object, Object object2) {
        Object object3;
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (object == null || object2 == null) {
            return null;
        }
        BeanProperty beanProperty = this.getBeanProperty(eLContext, object, object2);
        Method method = beanProperty.getReadMethod();
        if (method == null) {
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(eLContext, "propertyNotReadable", new Object[]{object.getClass().getName(), object2.toString()}));
        }
        try {
            object3 = method.invoke(object, new Object[0]);
            eLContext.setPropertyResolved(true);
        }
        catch (ELException eLException) {
            throw eLException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ELException(invocationTargetException.getCause());
        }
        catch (Exception exception) {
            throw new ELException(exception);
        }
        return object3;
    }

    @Override
    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (object == null || object2 == null) {
            return;
        }
        if (this.isReadOnly) {
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString(eLContext, "resolverNotwritable", new Object[]{object.getClass().getName()}));
        }
        BeanProperty beanProperty = this.getBeanProperty(eLContext, object, object2);
        Method method = beanProperty.getWriteMethod();
        if (method == null) {
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString(eLContext, "propertyNotWritable", new Object[]{object.getClass().getName(), object2.toString()}));
        }
        try {
            method.invoke(object, object3);
            eLContext.setPropertyResolved(true);
        }
        catch (ELException eLException) {
            throw eLException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ELException(invocationTargetException.getCause());
        }
        catch (Exception exception) {
            if (null == object3) {
                object3 = "null";
            }
            String string = ELUtil.getExceptionMessageString(eLContext, "setPropertyFailed", new Object[]{object2.toString(), object.getClass().getName(), object3});
            throw new ELException(string, exception);
        }
    }

    @Override
    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (object == null || object2 == null) {
            return false;
        }
        eLContext.setPropertyResolved(true);
        if (this.isReadOnly) {
            return true;
        }
        BeanProperty beanProperty = this.getBeanProperty(eLContext, object, object2);
        return beanProperty.isReadOnly();
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        if (object == null) {
            return null;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (beanInfo == null) {
            return null;
        }
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>(beanInfo.getPropertyDescriptors().length);
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            propertyDescriptor.setValue("type", propertyDescriptor.getPropertyType());
            propertyDescriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
            arrayList.add(propertyDescriptor);
        }
        return arrayList.iterator();
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext eLContext, Object object) {
        if (object == null) {
            return null;
        }
        return Object.class;
    }

    private static Method getMethod(Class clazz, Method method) {
        GenericDeclaration genericDeclaration;
        if (method == null) {
            return null;
        }
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            genericDeclaration = classArray[i];
            Method method2 = null;
            try {
                method2 = ((Class)genericDeclaration).getMethod(method.getName(), method.getParameterTypes());
                genericDeclaration = method2.getDeclaringClass();
                method2 = BeanELResolver.getMethod((Class)genericDeclaration, method2);
                if (method2 == null) continue;
                return method2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<Object> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            genericDeclaration = null;
            try {
                genericDeclaration = clazz2.getMethod(method.getName(), method.getParameterTypes());
                clazz2 = ((Method)genericDeclaration).getDeclaringClass();
                genericDeclaration = BeanELResolver.getMethod(clazz2, (Method)genericDeclaration);
                if (genericDeclaration != null) {
                    return genericDeclaration;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private BeanProperty getBeanProperty(ELContext eLContext, Object object, Object object2) {
        BeanProperty beanProperty;
        String string = object2.toString();
        Class<?> clazz = object.getClass();
        BeanProperties beanProperties = properties.get(clazz);
        if (beanProperties == null) {
            beanProperties = new BeanProperties(clazz);
            properties.putIfAbsent(clazz, beanProperties);
        }
        if ((beanProperty = beanProperties.getBeanProperty(string)) == null) {
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(eLContext, "propertyNotFound", new Object[]{clazz.getName(), string}));
        }
        return beanProperty;
    }

    private void removeFromMap(Map<Class, BeanProperties> map, ClassLoader classLoader) {
        Iterator<Class> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz = iterator.next();
            if (!classLoader.equals(clazz.getClassLoader())) continue;
            iterator.remove();
        }
    }

    private void purgeBeanClasses(ClassLoader classLoader) {
        this.removeFromMap(properties, classLoader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BeanProperties {
        private final Map<String, BeanProperty> propertyMap = new HashMap<String, BeanProperty>();

        public BeanProperties(Class<?> clazz) {
            PropertyDescriptor[] propertyDescriptorArray;
            try {
                PropertyDescriptor[] propertyDescriptorArray2 = Introspector.getBeanInfo(clazz);
                propertyDescriptorArray = propertyDescriptorArray2.getPropertyDescriptors();
            }
            catch (IntrospectionException introspectionException) {
                throw new ELException(introspectionException);
            }
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                this.propertyMap.put(propertyDescriptor.getName(), new BeanProperty(clazz, propertyDescriptor));
            }
        }

        public BeanProperty getBeanProperty(String string) {
            return this.propertyMap.get(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BeanProperty {
        private Method readMethod;
        private Method writeMethod;
        private PropertyDescriptor descriptor;

        public BeanProperty(Class<?> clazz, PropertyDescriptor propertyDescriptor) {
            this.descriptor = propertyDescriptor;
            this.readMethod = BeanELResolver.getMethod(clazz, propertyDescriptor.getReadMethod());
            this.writeMethod = BeanELResolver.getMethod(clazz, propertyDescriptor.getWriteMethod());
        }

        public Class getPropertyType() {
            return this.descriptor.getPropertyType();
        }

        public boolean isReadOnly() {
            return this.getWriteMethod() == null;
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }
    }
}

