/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transaction.Transaction;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.DispatchException;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.DefaultReplyToHandler;
import org.mule.transport.jms.Jms102bSupport;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsMessageUtils;
import org.mule.transport.jms.i18n.JmsMessages;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;

public class JmsReplyToHandler
extends DefaultReplyToHandler {
    private final JmsConnector connector;

    public JmsReplyToHandler(JmsConnector connector, List transformers) {
        super(transformers, connector.getMuleContext());
        this.connector = connector;
    }

    public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
        Destination replyToDestination = null;
        MessageProducer replyToProducer = null;
        Session session = null;
        try {
            if (replyTo instanceof Destination) {
                replyToDestination = (Destination)replyTo;
            }
            if (replyToDestination == null) {
                super.processReplyTo(event, returnMessage, replyTo);
                return;
            }
            Class<?> srcType = returnMessage.getPayload().getClass();
            for (Transformer t : this.getTransformers()) {
                if (!t.isSourceTypeSupported(srcType) || t.getEndpoint() != null) continue;
                t.setEndpoint((ImmutableEndpoint)this.getEndpoint(event, "jms://temporary"));
                break;
            }
            returnMessage.applyTransformers(this.getTransformers());
            Object payload = returnMessage.getPayload();
            if (replyToDestination instanceof Topic && replyToDestination instanceof Queue && this.connector.getJmsSupport() instanceof Jms102bSupport) {
                this.logger.error((Object)StringMessageUtils.getBoilerPlate((String)"ReplyTo destination implements both Queue and Topic while complying with JMS 1.0.2b specification. Please report your application server or JMS vendor name and version to dev<_at_>mule.codehaus.org or http://mule.mulesource.org/jira"));
            }
            boolean topic = this.connector.getTopicResolver().isTopic(replyToDestination);
            session = this.connector.getSession(false, topic);
            Message replyToMessage = JmsMessageUtils.toMessage(payload, session);
            this.processMessage(replyToMessage, event);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sending jms reply to: " + replyToDestination + "(" + replyToDestination.getClass().getName() + ")"));
            }
            replyToProducer = this.connector.getJmsSupport().createProducer(session, replyToDestination, topic);
            MuleMessage eventMsg = event.getMessage();
            String ttlString = (String)eventMsg.removeProperty("timeToLive");
            String priorityString = (String)eventMsg.removeProperty("priority");
            String persistentDeliveryString = (String)eventMsg.removeProperty("persistentDelivery");
            String correlationIDString = replyToMessage.getJMSCorrelationID();
            if (StringUtils.isBlank((String)correlationIDString)) {
                correlationIDString = (String)eventMsg.getProperty("JMSMessageID");
                replyToMessage.setJMSCorrelationID(correlationIDString);
            }
            event.getService().getStatistics().incSentReplyToEvent();
            ImmutableEndpoint endpoint = event.getEndpoint();
            if (ttlString == null && priorityString == null && persistentDeliveryString == null) {
                this.connector.getJmsSupport().send(replyToProducer, replyToMessage, topic, endpoint);
            } else {
                long ttl = 0L;
                int priority = 4;
                if (ttlString != null) {
                    ttl = Long.parseLong(ttlString);
                }
                if (priorityString != null) {
                    priority = Integer.parseInt(priorityString);
                }
                boolean persistent = StringUtils.isNotBlank((String)persistentDeliveryString) ? Boolean.valueOf(persistentDeliveryString).booleanValue() : this.connector.isPersistentDelivery();
                this.connector.getJmsSupport().send(replyToProducer, replyToMessage, persistent, priority, ttl, topic, endpoint);
            }
            this.logger.info((Object)("Reply Message sent to: " + replyToDestination + " with correlationID:" + correlationIDString));
            this.connector.closeQuietly(replyToProducer);
        }
        catch (Exception e) {
            throw new DispatchException(JmsMessages.failedToCreateAndDispatchResponse(replyToDestination), returnMessage, null, (Throwable)e);
        }
        finally {
            this.connector.closeQuietly(replyToProducer);
            Transaction transaction = TransactionCoordination.getInstance().getTransaction();
            if (transaction == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Closing non-TX replyTo session: " + session));
                }
                this.connector.closeQuietly(session);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not closing TX replyTo session: " + session));
            }
        }
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (transaction == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing non-TX replyTo session: " + session));
            }
            this.connector.closeQuietly(session);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Not closing TX replyTo session: " + session));
        }
    }

    protected void processMessage(Message replyToMessage, MuleEvent event) throws JMSException {
        replyToMessage.setJMSReplyTo(null);
        MuleMessage eventMsg = event.getMessage();
        Object jmsCorrelationId = eventMsg.getProperty("JMSCorrelationID");
        if (jmsCorrelationId == null) {
            jmsCorrelationId = eventMsg.getProperty("JMSMessageID");
        }
        if (jmsCorrelationId != null) {
            replyToMessage.setJMSCorrelationID(jmsCorrelationId.toString());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("replyTomessage is " + replyToMessage));
        }
    }
}

