/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.xa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.Session;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transaction.Transaction;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.XaTransaction;
import org.mule.transport.jms.xa.ConsumerProducerInvocationHandler;
import org.mule.transport.jms.xa.TargetInvocationHandler;
import org.mule.transport.jms.xa.XAResourceWrapper;

public class SessionInvocationHandler
implements TargetInvocationHandler {
    protected static final transient Log logger = LogFactory.getLog(SessionInvocationHandler.class);
    private XASession xaSession;
    private XAResource xaResource;
    private volatile boolean enlisted = false;
    private volatile boolean reuseObject = false;
    private final Session session;

    private SessionInvocationHandler(XASession xaSession, Session session) {
        this.xaSession = xaSession;
        this.session = session;
        this.xaResource = new XAResourceWrapper(xaSession.getXAResource(), this);
    }

    public SessionInvocationHandler(XASession xaSession) throws JMSException {
        this(xaSession, xaSession.getSession());
    }

    public SessionInvocationHandler(XAQueueSession xaSession) throws JMSException {
        this((XASession)xaSession, (Session)xaSession.getQueueSession());
    }

    public SessionInvocationHandler(XATopicSession xaSession) throws JMSException {
        this((XASession)xaSession, (Session)xaSession.getTopicSession());
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this + " Invoking " + method));
        }
        if ("delist".equals(method.getName())) {
            return this.delist();
        }
        if ("enlist".equals(method.getName())) {
            return this.enlist();
        }
        if ("setReuseObject".equals(method.getName())) {
            this.reuseObject = (Boolean)args[0];
            return null;
        }
        if ("isReuseObject".equals(method.getName())) {
            return this.reuseObject;
        }
        if ("getTargetObject".equals(method.getName())) {
            return this.getTargetObject();
        }
        if ("close".equals(method.getName())) {
            block20: {
                try {
                    this.session.close();
                    this.xaSession.close();
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block20;
                    logger.debug((Object)"Closing the session and the xaSession failed", (Throwable)ex);
                }
            }
            return null;
        }
        Object result = method.invoke((Object)this.session, args);
        if (result instanceof TopicSubscriber) {
            result = Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{TopicSubscriber.class}, (InvocationHandler)new ConsumerProducerInvocationHandler(this, result));
        } else if (result instanceof QueueReceiver) {
            result = Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{QueueReceiver.class}, (InvocationHandler)new ConsumerProducerInvocationHandler(this, result));
        } else if (result instanceof MessageConsumer) {
            result = Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{MessageConsumer.class}, (InvocationHandler)new ConsumerProducerInvocationHandler(this, result));
        } else if (result instanceof TopicPublisher) {
            result = Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{TopicPublisher.class}, (InvocationHandler)new ConsumerProducerInvocationHandler(this, result));
        } else if (result instanceof QueueSender) {
            result = Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{QueueSender.class}, (InvocationHandler)new ConsumerProducerInvocationHandler(this, result));
        } else if (result instanceof MessageProducer) {
            result = Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{MessageProducer.class}, (InvocationHandler)new ConsumerProducerInvocationHandler(this, result));
        }
        return result;
    }

    public boolean enlist() throws Exception {
        Transaction transaction;
        if (this.isEnlisted()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Enlistment request: " + this));
        }
        if ((transaction = TransactionCoordination.getInstance().getTransaction()) == null) {
            throw new IllegalTransactionStateException(CoreMessages.noMuleTransactionAvailable());
        }
        if (!(transaction instanceof XaTransaction)) {
            throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction((Object)transaction));
        }
        if (!this.isEnlisted()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Enlisting resource " + this.xaResource + " in xa transaction " + transaction));
            }
            this.enlisted = ((XaTransaction)transaction).enlistResource(this.xaResource);
        }
        return this.enlisted;
    }

    public boolean delist() throws Exception {
        Transaction transaction;
        if (!this.isEnlisted()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delistment request: " + this));
        }
        if ((transaction = TransactionCoordination.getInstance().getTransaction()) == null) {
            throw new IllegalTransactionStateException(CoreMessages.noMuleTransactionAvailable());
        }
        if (!(transaction instanceof XaTransaction)) {
            throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction((Object)transaction));
        }
        if (this.isEnlisted()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Delisting resource " + this.xaResource + " in xa transaction " + transaction));
            }
            this.enlisted = !((XaTransaction)transaction).delistResource(this.xaResource, 0x4000000);
        }
        return !this.isEnlisted();
    }

    public boolean isEnlisted() {
        return this.enlisted;
    }

    public void setEnlisted(boolean enlisted) {
        this.enlisted = enlisted;
    }

    public Object getTargetObject() {
        return this.xaSession;
    }

    public XAResource getXAResource() {
        return this.xaResource;
    }
}

