/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ftp;

import java.io.ByteArrayOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.resource.spi.work.Work;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.retry.RetryContext;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.ftp.FtpConnector;

public class FtpMessageReceiver
extends AbstractPollingMessageReceiver {
    protected final FtpConnector connector;
    protected final FilenameFilter filenameFilter;
    protected final Set<String> scheduledFiles = Collections.synchronizedSet(new HashSet());
    protected final Set<String> currentFiles = Collections.synchronizedSet(new HashSet());

    public FtpMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint, long frequency) throws CreateException {
        super(connector, service, endpoint);
        this.setFrequency(frequency);
        this.connector = (FtpConnector)connector;
        this.filenameFilter = endpoint.getFilter() instanceof FilenameFilter ? (FilenameFilter)endpoint.getFilter() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws Exception {
        FTPFile[] files = this.listFiles();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Poll encountered " + files.length + " new file(s)"));
        }
        Set<String> set = this.scheduledFiles;
        synchronized (set) {
            for (FTPFile file : files) {
                String fileName = file.getName();
                if (this.scheduledFiles.contains(fileName) || this.currentFiles.contains(fileName)) continue;
                this.scheduledFiles.add(fileName);
                this.getWorkManager().scheduleWork((Work)new FtpWork(fileName, file));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FTPFile[] listFiles() throws Exception {
        FTPClient client = null;
        try {
            try {
                client = this.connector.createFtpClient(this.endpoint);
            }
            catch (Exception e) {
                throw new ConnectException((Throwable)e, (Object)this);
            }
            FTPFile[] files = client.listFiles();
            if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                throw new IOException("Failed to list files. Ftp error: " + client.getReplyCode());
            }
            if (files == null || files.length == 0) {
                FTPFile[] fTPFileArray = files;
                return fTPFileArray;
            }
            ArrayList<FTPFile> v = new ArrayList<FTPFile>();
            for (FTPFile file : files) {
                if (!file.isFile() || this.filenameFilter != null && !this.filenameFilter.accept(null, file.getName())) continue;
                v.add(file);
            }
            FTPFile[] fTPFileArray = v.toArray(new FTPFile[v.size()]);
            return fTPFileArray;
        }
        finally {
            if (client != null) {
                this.connector.releaseFtp(this.endpoint.getEndpointURI(), client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processFile(FTPFile file) throws Exception {
        DefaultMuleMessage message;
        FTPClient client;
        block9: {
            client = null;
            try {
                if (this.connector.validateFile(file)) break block9;
                if (client == null) return;
            }
            catch (Throwable throwable) {
                if (client == null) throw throwable;
                this.connector.releaseFtp(this.endpoint.getEndpointURI(), client);
                throw throwable;
            }
            this.connector.releaseFtp(this.endpoint.getEndpointURI(), client);
            return;
        }
        try {
            client = this.connector.createFtpClient(this.endpoint);
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
        if (this.connector.isStreaming()) {
            InputStream stream = client.retrieveFileStream(file.getName());
            if (stream == null) {
                throw new IOException(MessageFormat.format("Failed to retrieve file {0}. Ftp error: {1}", file.getName(), client.getReplyCode()));
            }
            message = new DefaultMuleMessage((Object)this.connector.getMessageAdapter(stream), this.connector.getMuleContext());
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (!client.retrieveFile(file.getName(), (OutputStream)baos)) {
                throw new IOException(MessageFormat.format("Failed to retrieve file {0}. Ftp error: {1}", file.getName(), client.getReplyCode()));
            }
            byte[] bytes = baos.toByteArray();
            if (bytes.length <= 0) throw new IOException("File " + file.getName() + " is empty (zero bytes)");
            message = new DefaultMuleMessage((Object)this.connector.getMessageAdapter(bytes), this.connector.getMuleContext());
        }
        message.setProperty("originalFilename", (Object)file.getName());
        message.setProperty("fileSize", (Object)file.getSize());
        message.setProperty("timestamp", (Object)file.getTimestamp());
        this.routeMessage((MuleMessage)message);
        this.postProcess(client, file, (MuleMessage)message);
        if (client == null) return;
        this.connector.releaseFtp(this.endpoint.getEndpointURI(), client);
    }

    protected void postProcess(FTPClient client, FTPFile file, MuleMessage message) throws Exception {
        if (!client.deleteFile(file.getName())) {
            throw new IOException(MessageFormat.format("Failed to delete file {0}. Ftp error: {1}", file.getName(), client.getReplyCode()));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted processed file " + file.getName()));
        }
        if (this.connector.isStreaming() && !client.completePendingCommand()) {
            throw new IOException(MessageFormat.format("Failed to complete a pending command. Retrieveing file {0}. Ftp error: {1}", file.getName(), client.getReplyCode()));
        }
    }

    protected void doConnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryContext validateConnection(RetryContext retryContext) {
        FTPClient client = null;
        try {
            client = this.connector.createFtpClient(this.endpoint);
            client.sendNoOp();
            client.logout();
            client.disconnect();
            retryContext.setOk();
        }
        catch (Exception ex) {
            retryContext.setFailed((Throwable)ex);
        }
        finally {
            block13: {
                try {
                    if (client != null) {
                        this.connector.releaseFtp(this.endpoint.getEndpointURI(), client);
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block13;
                    this.logger.debug((Object)("Failed to release ftp client " + client), (Throwable)e);
                }
            }
        }
        return retryContext;
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    private final class FtpWork
    implements Work {
        private final String name;
        private final FTPFile file;

        private FtpWork(String name, FTPFile file) {
            this.name = name;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                FtpMessageReceiver.this.currentFiles.add(this.name);
                FtpMessageReceiver.this.processFile(this.file);
            }
            catch (Exception e) {
                FtpMessageReceiver.this.connector.handleException(e);
            }
            finally {
                FtpMessageReceiver.this.currentFiles.remove(this.name);
                FtpMessageReceiver.this.scheduledFiles.remove(this.name);
            }
        }

        public void release() {
        }
    }
}

