/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.atom.routing;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.routing.InboundRouter;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.module.atom.transformers.ObjectToFeed;
import org.mule.routing.AbstractRouter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InboundFeedSplitter
extends AbstractRouter
implements InboundRouter {
    protected final transient Log logger = LogFactory.getLog(InboundFeedSplitter.class);
    public static final String FEED_PROPERTY = "feed.object";
    private Filter entryFilter;
    private List<String> acceptedContentTypes;
    private ObjectToFeed objectToFeed = new ObjectToFeed();

    public InboundFeedSplitter() {
        this.acceptedContentTypes = new ArrayList<String>();
        this.acceptedContentTypes.add("application/atom+xml");
    }

    @Override
    public MuleEvent[] process(MuleEvent muleEvent) throws MessagingException {
        try {
            Object payload = muleEvent.getMessage().getPayload();
            Feed feed = payload instanceof Feed ? (Feed)payload : (Feed)this.objectToFeed.transform(muleEvent.getMessage().getPayload());
            ArrayList<DefaultMuleEvent> events = new ArrayList<DefaultMuleEvent>();
            TreeSet entries = new TreeSet(new EntryComparator());
            entries.addAll(feed.getEntries());
            for (Entry entry : entries) {
                DefaultMuleMessage m = new DefaultMuleMessage(entry, this.getMuleContext());
                if (this.entryFilter != null && !this.entryFilter.accept(m)) continue;
                m.setProperty(FEED_PROPERTY, feed, PropertyScope.INVOCATION);
                DefaultMuleEvent e = new DefaultMuleEvent((MuleMessage)m, muleEvent.getEndpoint(), muleEvent.getService(), muleEvent);
                events.add(e);
            }
            return events.toArray(new MuleEvent[0]);
        }
        catch (TransformerException e) {
            throw new MessagingException(e.getI18nMessage(), muleEvent.getMessage(), e);
        }
    }

    @Override
    public boolean isMatch(MuleEvent muleEvent) throws MessagingException {
        String contentType = muleEvent.getMessage().getStringProperty("Content-Type", null);
        if (contentType != null) {
            int i = contentType.indexOf(";");
            contentType = i > -1 ? contentType.substring(0, i) : contentType;
            return this.acceptedContentTypes.contains(contentType);
        }
        this.logger.warn((Object)"Content-Type header not set, not accepting the message");
        return false;
    }

    public Filter getEntryFilter() {
        return this.entryFilter;
    }

    public void setEntryFilter(Filter entryFilter) {
        this.entryFilter = entryFilter;
    }

    public List<String> getAcceptedContentTypes() {
        return this.acceptedContentTypes;
    }

    public void setAcceptedContentTypes(List<String> acceptedContentTypes) {
        this.acceptedContentTypes = acceptedContentTypes;
    }

    class EntryComparator
    implements Comparator {
        EntryComparator() {
        }

        public int compare(Object o1, Object o2) {
            Entry e1 = (Entry)o1;
            Entry e2 = (Entry)o2;
            if (e1.getPublished().before(e2.getPublished())) {
                return -1;
            }
            if (e1.equals(e2)) {
                return 0;
            }
            return 1;
        }
    }
}

