/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.guice;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.NamedObject;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.registry.RegistrationException;
import org.mule.endpoint.DefaultEndpointFactory;
import org.mule.module.guice.i18n.GuiceMessages;

public abstract class AbstractMuleGuiceModule
extends AbstractModule {
    protected MuleContext muleContext;

    void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.configureMuleContext(this.muleContext);
    }

    public void configureMuleContext(MuleContext muleContext) {
    }

    protected final void configure() {
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> iTypeLiteral, TypeEncounter<I> iTypeEncounter) {
                iTypeEncounter.register((InjectionListener)new MuleRegistryInjectionLister());
            }
        });
        this.bind(MuleContext.class).toInstance((Object)this.muleContext);
        try {
            this.doConfigure();
        }
        catch (Exception e) {
            this.addError(e);
        }
    }

    protected abstract void doConfigure() throws Exception;

    protected EndpointBuilder createEndpointBuilder(String uri) throws MuleException {
        DefaultEndpointFactory endpointFactory = new DefaultEndpointFactory();
        endpointFactory.setMuleContext(this.muleContext);
        return endpointFactory.getEndpointBuilder(uri);
    }

    protected void initialiseObject(Object o) throws RegistrationException {
        if (o instanceof NamedObject) {
            this.muleContext.getRegistry().registerObject(((NamedObject)o).getName(), o);
        } else {
            this.muleContext.getRegistry().registerObject(String.valueOf(o.getClass().getSimpleName() + "#" + o.hashCode()), o);
        }
    }

    private class MuleRegistryInjectionLister
    implements InjectionListener {
        public void afterInjection(Object o) {
            if (o instanceof MuleContext) {
                return;
            }
            try {
                AbstractMuleGuiceModule.this.initialiseObject(o);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(GuiceMessages.failedToRegisterOBjectWithMule(o.getClass()), (Throwable)e);
            }
        }
    }
}

