/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.ResponseOutputStream;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.registry.ServiceType;
import org.mule.api.security.Credentials;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.security.MuleCredentials;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.UUID;
import org.mule.util.store.DeserializationPostInitialisable;

public class DefaultMuleEvent
extends EventObject
implements MuleEvent,
ThreadSafeAccess,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 1L;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private transient ImmutableEndpoint endpoint = null;
    private String id = null;
    private MuleMessage message = null;
    private MuleSession session;
    private boolean stopFurtherProcessing = false;
    private boolean synchronous = false;
    private int timeout = Integer.MIN_VALUE;
    private transient ResponseOutputStream outputStream = null;
    private transient Object transformedMessage = null;
    private Credentials credentials = null;
    protected String[] ignoredPropertyOverrides = new String[]{"method"};
    private transient Map<String, Object> serializedData = null;

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, Service service, MuleEvent previousEvent) {
        super(message.getPayload());
        this.message = message;
        this.id = this.generateEventId();
        this.session = previousEvent.getSession();
        ((DefaultMuleSession)this.session).setService(service);
        this.endpoint = endpoint;
        this.synchronous = previousEvent.isSynchronous();
        this.timeout = previousEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)previousEvent.getOutputStream();
        this.fillProperties(previousEvent);
    }

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, MuleSession session, boolean synchronous) {
        this(message, endpoint, session, synchronous, null);
    }

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, MuleSession session, boolean synchronous, ResponseOutputStream outputStream) {
        super(message.getPayload());
        this.message = message;
        this.endpoint = endpoint;
        this.session = session;
        this.id = this.generateEventId();
        this.synchronous = synchronous;
        this.outputStream = outputStream;
        this.fillProperties(null);
    }

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, MuleSession session, String eventId, boolean synchronous) {
        super(message.getPayload());
        this.message = message;
        this.endpoint = endpoint;
        this.session = session;
        this.id = eventId;
        this.synchronous = synchronous;
        this.fillProperties(null);
    }

    public DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent) {
        super(message.getPayload());
        this.message = message;
        this.id = rewriteEvent.getId();
        this.session = rewriteEvent.getSession();
        ((DefaultMuleSession)this.session).setService(rewriteEvent.getService());
        this.endpoint = rewriteEvent.getEndpoint();
        this.synchronous = rewriteEvent.isSynchronous();
        this.timeout = rewriteEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)rewriteEvent.getOutputStream();
        if (rewriteEvent instanceof DefaultMuleEvent) {
            this.transformedMessage = ((DefaultMuleEvent)rewriteEvent).getCachedMessage();
        }
        this.fillProperties(rewriteEvent);
    }

    protected void fillProperties(MuleEvent previousEvent) {
        if (this.endpoint != null && this.endpoint.getProperties() != null) {
            for (String prop : this.endpoint.getProperties().keySet()) {
                Object value = this.endpoint.getProperties().get(prop);
                if (this.ignoreProperty(prop)) continue;
                this.message.setProperty(prop, value, PropertyScope.INVOCATION);
            }
        }
        this.setCredentials();
    }

    protected boolean ignoreProperty(String key) {
        if (key == null) {
            return true;
        }
        for (int i = 0; i < this.ignoredPropertyOverrides.length; ++i) {
            if (!key.equals(this.ignoredPropertyOverrides[i])) continue;
            return false;
        }
        return null != this.message.getProperty(key);
    }

    protected void setCredentials() {
        if (null != this.endpoint && null != this.endpoint.getEndpointURI() && null != this.endpoint.getEndpointURI().getUserInfo()) {
            String userName = this.endpoint.getEndpointURI().getUser();
            String password = this.endpoint.getEndpointURI().getPassword();
            if (password != null && userName != null) {
                this.credentials = new MuleCredentials(userName, password.toCharArray());
            }
        }
    }

    public Credentials getCredentials() {
        return this.credentials != null ? this.credentials : (MuleCredentials)this.message.getProperty("MULE_CREDENTIALS");
    }

    Object getCachedMessage() {
        return this.transformedMessage;
    }

    public MuleMessage getMessage() {
        return this.message;
    }

    public byte[] getMessageAsBytes() throws DefaultMuleException {
        try {
            return this.message.getPayloadAsBytes();
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsBytes(this.message.getPayload().getClass().getName()), (Throwable)e);
        }
    }

    public Object transformMessage() throws TransformerException {
        return this.transformMessage(null);
    }

    public Object transformMessage(Class outputType) throws TransformerException {
        this.message.applyTransformers(this.endpoint.getTransformers());
        if (outputType == null) {
            return this.message.getPayload();
        }
        return this.message.getPayload(outputType);
    }

    public byte[] transformMessageToBytes() throws TransformerException {
        return (byte[])this.transformMessage(byte[].class);
    }

    public String transformMessageToString() throws TransformerException {
        try {
            return new String(this.transformMessageToBytes(), this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformerException(this.endpoint.getTransformers(), (Throwable)e);
        }
    }

    public String getMessageAsString() throws MuleException {
        return this.getMessageAsString(this.getEncoding());
    }

    public String getMessageAsString(String encoding) throws MuleException {
        try {
            return this.message.getPayloadAsString(encoding);
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsString(this.message.getClass().getName()), (Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public Object getProperty(String name) {
        return this.getProperty(name, null);
    }

    public Object getProperty(String name, Object defaultValue) {
        Object property = this.message.getProperty(name);
        if (property == null) {
            property = this.session.getProperty(name);
        }
        return property == null ? defaultValue : property;
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("MuleEvent: ").append(this.getId());
        buf.append(", sync=").append(this.isSynchronous());
        buf.append(", stop processing=").append(this.isStopFurtherProcessing());
        buf.append(", ").append(this.endpoint);
        return buf.toString();
    }

    protected String generateEventId() {
        return UUID.getUUID();
    }

    public MuleSession getSession() {
        return this.session;
    }

    void setSession(MuleSession session) {
        this.session = session;
    }

    public Service getService() {
        return this.session.getService();
    }

    public boolean isStopFurtherProcessing() {
        return this.stopFurtherProcessing;
    }

    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        this.stopFurtherProcessing = stopFurtherProcessing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultMuleEvent)) {
            return false;
        }
        DefaultMuleEvent event = (DefaultMuleEvent)o;
        if (this.message != null ? !this.message.equals(event.message) : event.message != null) {
            return false;
        }
        return this.id.equals(event.id);
    }

    public int hashCode() {
        return 29 * this.id.hashCode() + (this.message != null ? this.message.hashCode() : 0);
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean value) {
        this.synchronous = value;
    }

    public int getTimeout() {
        if (this.timeout == Integer.MIN_VALUE) {
            this.timeout = this.endpoint.getResponseTimeout();
        }
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.endpoint.hashCode());
        out.writeBoolean(this.endpoint instanceof InboundEndpoint);
        out.writeObject(this.endpoint.getEndpointBuilderName());
        String uri = this.endpoint.getEndpointURI().getUri().toString();
        String connectorName = this.endpoint.getConnector().getName();
        out.writeObject(uri + "?connector=" + connectorName);
        out.writeInt(this.endpoint.getTransformers().size());
        if (this.endpoint.getTransformers().size() > 0) {
            for (Transformer transformer : this.endpoint.getTransformers()) {
                out.writeObject(transformer.getName());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, MuleException {
        this.logger = LogFactory.getLog(this.getClass());
        in.defaultReadObject();
        this.serializedData = new HashMap<String, Object>();
        this.serializedData.put("endpointHashcode", in.readInt());
        this.serializedData.put("isInboundEndpoint", in.readBoolean());
        this.serializedData.put("endpointBuilderName", in.readObject());
        this.serializedData.put("endpointUri", in.readObject());
        int count = in.readInt();
        LinkedList<String> transformerNames = new LinkedList<String>();
        if (count > 0) {
            while (--count > 0) {
                transformerNames.add((String)in.readObject());
            }
        }
        this.serializedData.put("transformers", transformerNames);
    }

    private void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
        if (this.session instanceof DefaultMuleSession) {
            ((DefaultMuleSession)this.session).initAfterDeserialisation(muleContext);
        }
        if (this.message instanceof DefaultMuleMessage) {
            ((DefaultMuleMessage)this.message).initAfterDeserialisation(muleContext);
        }
        int endpointHashcode = (Integer)this.serializedData.get("endpointHashcode");
        boolean isInboundEndpoint = (Boolean)this.serializedData.get("isInboundEndpoint");
        String endpointBuilderName = (String)this.serializedData.get("endpointBuilderName");
        String endpointUri = (String)this.serializedData.get("endpointUri");
        List transformerNames = (List)this.serializedData.get("transformers");
        this.endpoint = (ImmutableEndpoint)muleContext.getRegistry().lookupObject("endpoint:" + endpointHashcode);
        if (this.endpoint == null) {
            if (endpointBuilderName != null && muleContext.getRegistry().lookupEndpointBuilder(endpointBuilderName) != null) {
                this.endpoint = isInboundEndpoint ? muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(endpointBuilderName) : muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointBuilderName);
            } else {
                LinkedList<Transformer> transformers = new LinkedList<Transformer>();
                for (String name : transformerNames) {
                    Transformer next = muleContext.getRegistry().lookupTransformer(name);
                    if (next == null) {
                        throw new IllegalStateException(CoreMessages.objectNotFound(name).toString());
                    }
                    transformers.add(next);
                }
                MuleEndpointURI uri = new MuleEndpointURI(endpointUri, muleContext);
                TransportServiceDescriptor tsd = (TransportServiceDescriptor)muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, uri.getFullScheme(), null);
                EndpointBuilder endpointBuilder = tsd.createEndpointBuilder(endpointUri);
                endpointBuilder.setTransformers(transformers);
                this.endpoint = isInboundEndpoint ? muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(endpointBuilder) : muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointBuilder);
            }
        }
        this.serializedData = null;
    }

    public String getEncoding() {
        String encoding = this.message.getEncoding();
        if (encoding == null) {
            encoding = this.endpoint.getEncoding();
        }
        return encoding;
    }

    public MuleContext getMuleContext() {
        return this.endpoint.getMuleContext();
    }

    public ThreadSafeAccess newThreadCopy() {
        if (this.message instanceof ThreadSafeAccess) {
            DefaultMuleEvent copy = new DefaultMuleEvent((MuleMessage)((Object)((ThreadSafeAccess)((Object)this.message)).newThreadCopy()), this);
            copy.resetAccessControl();
            return copy;
        }
        return this;
    }

    public void resetAccessControl() {
        if (this.message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)((Object)this.message)).resetAccessControl();
        }
    }

    public void assertAccess(boolean write) {
        if (this.message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)((Object)this.message)).assertAccess(write);
        }
    }
}

