/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecyclePair;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.registry.Registry;
import org.mule.lifecycle.DefaultLifecycleState;
import org.mule.lifecycle.phases.NotInLifecyclePhase;
import org.mule.util.StringMessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryLifecycleManager
implements LifecycleManager {
    private static final Log logger = LogFactory.getLog(RegistryLifecycleManager.class);
    protected static final NotInLifecyclePhase notInLifecyclePhase = new NotInLifecyclePhase();
    protected String currentPhase = notInLifecyclePhase.getName();
    protected String executingPhase = null;
    protected Set completedPhases = new LinkedHashSet(6);
    protected Set transitions = new LinkedHashSet(6);
    protected List<LifecyclePair> lifecyclePairs = new ArrayList<LifecyclePair>(3);
    protected LifecycleState state = new DefaultLifecycleState(this);
    private List<LifecyclePhase> index;

    @Override
    public List<LifecyclePair> getLifecyclePairs() {
        return this.lifecyclePairs;
    }

    @Override
    public void setLifecyclePairs(List<LifecyclePair> lifecyclePairs) {
        this.lifecyclePairs = lifecyclePairs;
    }

    @Override
    public void registerLifecycle(LifecyclePair lifecyclePair) {
        this.lifecyclePairs.add(lifecyclePair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePhase(MuleContext muleContext, String phase) throws MuleException {
        if (this.currentPhase.equalsIgnoreCase(phase)) {
            logger.debug((Object)("Already in lifecycle phase: " + phase));
            return;
        }
        LifecyclePhase li = this.lookupPhase(phase);
        if (!li.isPhaseSupported(this.currentPhase)) {
            throw new IllegalStateException("Lifecycle phase: " + phase + " does not support current phase: " + this.currentPhase + ". Phases supported are: " + StringMessageUtils.toString(li.getSupportedPhases()));
        }
        try {
            this.setExecutingPhase(phase);
            muleContext.getRegistry().fireLifecycle(phase);
            this.setCurrentPhase(li);
            Object var5_4 = null;
            this.setExecutingPhase(null);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setExecutingPhase(null);
            throw throwable;
        }
    }

    protected List<LifecyclePhase> getPhasesIndex() {
        if (this.index == null) {
            this.index = new ArrayList<LifecyclePhase>(this.lifecyclePairs.size() * 2 + 1);
            this.index.add(notInLifecyclePhase);
            for (LifecyclePair pair : this.lifecyclePairs) {
                this.index.add(pair.getBegin());
            }
            for (int i = this.lifecyclePairs.size() - 1; i >= 0; --i) {
                this.index.add(this.lifecyclePairs.get(i).getEnd());
            }
        }
        return this.index;
    }

    protected synchronized int getPhaseIndex(String phase) {
        int i = 0;
        for (LifecyclePhase lifecyclePhase : this.getPhasesIndex()) {
            if (lifecyclePhase.getName().equals(phase)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected synchronized LifecyclePhase getPhaseForIndex(int phaseIndex) {
        return this.getPhasesIndex().get(phaseIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doApplyPhase(Registry registry, String phase) throws MuleException {
        LifecyclePhase li = this.lookupPhase(phase);
        if (this.currentPhase.equalsIgnoreCase(phase)) {
            logger.debug((Object)("Already in lifecycle phase: " + phase));
            return;
        }
        if (!li.isPhaseSupported(this.currentPhase)) {
            throw new IllegalStateException("Lifecycle phase: " + phase + " does not support current phase: " + this.currentPhase + ". Phases supported are: " + StringMessageUtils.toString(li.getSupportedPhases()));
        }
        try {
            this.setExecutingPhase(phase);
            li.applyLifecycle(registry);
            this.setCurrentPhase(li);
            Object var5_4 = null;
            this.setExecutingPhase(null);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setExecutingPhase(null);
            throw throwable;
        }
    }

    @Override
    public void applyPhase(Object object, String phase) throws MuleException {
        int current = this.getPhaseIndex(this.currentPhase);
        int end = this.getPhaseIndex(phase);
        if (end < current) {
            logger.warn((Object)("Phase: " + phase + " has already been fired for this object: " + object));
            return;
        }
        ++current;
        while (current <= end) {
            LifecyclePhase li = this.getPhaseForIndex(current);
            li.applyLifecycle(object);
            ++current;
        }
    }

    @Override
    public void fireLifecycle(Registry registry, String phase) throws MuleException {
        int current = this.getPhaseIndex(this.currentPhase);
        int end = this.getPhaseIndex(phase);
        if (end < current) {
            LifecyclePhase li = this.getPhaseForIndex(end);
            this.doApplyPhase(registry, li.getName());
            return;
        }
        ++current;
        while (current <= end) {
            LifecyclePhase li = this.getPhaseForIndex(current);
            this.doApplyPhase(registry, li.getName());
            ++current;
        }
    }

    @Override
    public String getCurrentPhase() {
        return this.currentPhase;
    }

    @Override
    public String getExecutingPhase() {
        return this.executingPhase;
    }

    protected synchronized void setCurrentPhase(LifecyclePhase phase) {
        this.completedPhases.add(phase.getName());
        this.transitions.add(phase.getName());
        this.transitions.remove(phase.getOppositeLifecyclePhase());
        this.currentPhase = phase.getName();
    }

    protected synchronized void setExecutingPhase(String phase) {
        this.executingPhase = phase;
    }

    @Override
    public void reset() {
        this.setExecutingPhase(null);
        this.completedPhases.clear();
        this.transitions.clear();
        this.setCurrentPhase(notInLifecyclePhase);
    }

    @Override
    public boolean isPhaseComplete(String phaseName) {
        return this.transitions.contains(phaseName);
    }

    @Override
    public void applyCompletedPhases(Object object) throws MuleException {
        LifecyclePhase lcp;
        Integer phaseIndex;
        logger.debug((Object)("applying lifecycle to " + object));
        for (Object completedPhase : this.completedPhases) {
            String phase = (String)completedPhase;
            phaseIndex = this.getPhaseIndex(phase);
            lcp = this.getPhaseForIndex(phaseIndex);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("phase: " + lcp));
            }
            lcp.applyLifecycle(object);
        }
        if (this.getExecutingPhase() != null) {
            phaseIndex = this.getPhaseIndex(this.getExecutingPhase());
            lcp = this.getPhaseForIndex(phaseIndex);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("and executing: " + lcp));
            }
            lcp.applyLifecycle(object);
        }
    }

    @Override
    public void checkPhase(String name) throws IllegalStateException {
        if (this.executingPhase != null) {
            if (name.equalsIgnoreCase(this.executingPhase)) {
                throw new IllegalStateException("Phase '" + name + "' is already currently being executed");
            }
            throw new IllegalStateException("Currently executing lifecycle phase: " + this.executingPhase);
        }
        if (name.equalsIgnoreCase(this.currentPhase)) {
            throw new IllegalStateException("Already in lifecycle phase '" + name + "', cannot fire the same phase twice");
        }
        Integer phaseIndex = this.getPhaseIndex(name);
        if (phaseIndex == null) {
            throw new IllegalStateException("Phase does not exist: " + name);
        }
        LifecyclePhase phase = this.getPhaseForIndex(phaseIndex);
        if (!phase.isPhaseSupported(this.currentPhase)) {
            throw new IllegalStateException("Lifecycle phase: " + this.currentPhase + " does not support current phase: " + phase.getName() + ". Phases supported are: " + StringMessageUtils.toString(phase.getSupportedPhases()));
        }
    }

    protected LifecyclePhase lookupPhase(String phase) throws IllegalArgumentException {
        Integer phaseIndex = this.getPhaseIndex(phase);
        if (phaseIndex == null) {
            throw new IllegalArgumentException("No lifecycle phase registered with name: " + phase);
        }
        return this.getPhaseForIndex(phaseIndex);
    }

    @Override
    public LifecycleState getState() {
        return this.state;
    }
}

