/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.resolvers;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.api.MuleEventContext;
import org.mule.api.model.InvocationResult;
import org.mule.model.resolvers.ReflectionEntryPointResolver;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArgumentEntryPointResolver
extends ReflectionEntryPointResolver {
    private Set methods = new HashSet(2);
    private boolean enableDiscovery = true;

    public AbstractArgumentEntryPointResolver() {
        this.setAcceptVoidMethods(true);
        this.setIgnoredMethods(new HashSet<String>(Arrays.asList("toString", "getClass", "notify", "notifyAll", "wait", "hashCode", "clone", "is*", "get*")));
    }

    public Set getMethods() {
        return this.methods;
    }

    public void setMethods(Set methods) {
        this.methods = methods;
    }

    public void addMethod(String name) {
        this.methods.add(name);
    }

    public boolean removeMethod(String name) {
        return this.methods.remove(name);
    }

    public boolean isEnableDiscovery() {
        return this.enableDiscovery;
    }

    public void setEnableDiscovery(boolean enableDiscovery) {
        this.enableDiscovery = enableDiscovery;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public InvocationResult invoke(Object component, MuleEventContext context) throws Exception {
        Method method = null;
        Object[] payload = this.getPayloadFromMessage(context);
        if (payload == null) {
            return new InvocationResult(0);
        }
        for (String methodName : this.methods) {
            method = this.getMethodByName(methodName, context);
            if (method == null) {
                method = ClassUtils.getMethod(component.getClass(), methodName, this.getMethodArgumentTypes(payload));
            }
            if (method == null) continue;
            this.addMethodByName(method, context);
            break;
        }
        if (method != null) return this.invokeMethod(component, method, this.getPayloadFromMessage(context));
        if (!this.isEnableDiscovery()) {
            InvocationResult result = new InvocationResult(2);
            result.setErrorNoMatchingMethodsCalled(component, StringMessageUtils.toString(this.methods), this);
            return result;
        }
        Class[] argTypes = this.getMethodArgumentTypes(payload);
        List methods = ClassUtils.getSatisfiableMethods(component.getClass(), argTypes, this.isAcceptVoidMethods(), false, this.getIgnoredMethods(), this.filter);
        if (methods.size() > 1) {
            InvocationResult result = new InvocationResult(2);
            result.setErrorTooManyMatchingMethods(component, argTypes, this);
            return result;
        }
        if (methods.size() == 1) {
            method = this.addMethodByArguments(component, (Method)methods.get(0), this.getPayloadFromMessage(context));
            return this.invokeMethod(component, method, this.getPayloadFromMessage(context));
        }
        InvocationResult result = new InvocationResult(2);
        result.setErrorNoMatchingMethods(component, ClassUtils.NO_ARGS_TYPE, this);
        return result;
    }

    protected abstract Class<?>[] getMethodArgumentTypes(Object[] var1);

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ClassUtils.getClassName(this.getClass()));
        sb.append("{methods=").append(StringMessageUtils.toString(this.methods));
        sb.append("{transformFirst=").append(this.isTransformFirst());
        sb.append(", acceptVoidMethods=").append(this.isAcceptVoidMethods());
        sb.append('}');
        return sb.toString();
    }
}

