/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import org.mule.OptimizedRequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.ResponseRouter;
import org.mule.api.routing.ResponseRouterCollection;
import org.mule.api.routing.Router;
import org.mule.api.routing.RoutingException;
import org.mule.routing.AbstractRouterCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResponseRouterCollection
extends AbstractRouterCollection
implements ResponseRouterCollection {
    private volatile List<InboundEndpoint> endpoints = new CopyOnWriteArrayList();
    private volatile int timeout = -1;
    private volatile boolean failOnTimeout = true;

    public DefaultResponseRouterCollection() {
        super(3);
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.timeout == -1) {
            this.setTimeout(this.muleContext.getConfiguration().getDefaultResponseTimeout());
        }
        super.initialise();
    }

    @Override
    public void route(MuleEvent event) throws RoutingException {
        for (ResponseRouter responseRouter : this.getRouters()) {
            responseRouter.process(event);
            if (!this.getStatistics().isEnabled()) continue;
            this.getStatistics().incrementRoutedMessage(event.getEndpoint());
        }
    }

    @Override
    public MuleMessage getResponse(MuleMessage message) throws RoutingException {
        MuleMessage result = null;
        if (this.routers.size() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"There are no routers configured on the response router. Returning the current message");
            }
        } else {
            for (ResponseRouter responseRouter : this.getRouters()) {
                result = responseRouter.getResponse(message);
            }
            if (result == null && this.getStatistics().isEnabled()) {
                this.getStatistics().incrementNoRoutedMessage();
            }
            return OptimizedRequestContext.unsafeRewriteEvent(result);
        }
        result = message;
        return result;
    }

    @Override
    public void addRouter(Router router) {
        ((ResponseRouter)router).setTimeout(this.getTimeout());
        ((ResponseRouter)router).setFailOnTimeout(this.isFailOnTimeout());
        this.routers.add(router);
    }

    @Override
    public ResponseRouter removeRouter(ResponseRouter router) {
        if (this.routers.remove(router)) {
            return router;
        }
        return null;
    }

    @Override
    public void addEndpoint(InboundEndpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint = null");
        }
        this.endpoints.add(endpoint);
    }

    @Override
    public boolean removeEndpoint(InboundEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    @Override
    public List<InboundEndpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public void setEndpoints(List<InboundEndpoint> endpoints) {
        if (endpoints == null) {
            throw new IllegalArgumentException("List of endpoints = null");
        }
        this.endpoints.clear();
        this.endpoints.addAll(endpoints);
    }

    @Override
    public InboundEndpoint getEndpoint(String name) {
        for (InboundEndpoint endpoint : this.endpoints) {
            if (!endpoint.getName().equals(name)) continue;
            return endpoint;
        }
        return null;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    @Override
    public boolean hasEndpoints() {
        return !this.getEndpoints().isEmpty();
    }
}

