/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerChain
extends AbstractMessageAwareTransformer {
    private List<Transformer> transformers;

    public TransformerChain(List<Transformer> transformers) {
        if (transformers.size() < 1) {
            throw new IllegalArgumentException("You must set at least one transformer");
        }
        this.transformers = new LinkedList<Transformer>(transformers);
    }

    public TransformerChain(Transformer ... transformers) {
        this(Arrays.asList(transformers));
        this.name = this.generateTransformerName();
    }

    public TransformerChain(String name, List<Transformer> transformers) {
        this(transformers);
        this.name = name;
    }

    public TransformerChain(String name, Transformer ... transformers) {
        this(name, Arrays.asList(transformers));
    }

    @Override
    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        MuleMessage result = message;
        Object temp = message;
        Transformer lastTransformer2 = null;
        for (Transformer lastTransformer2 : this.transformers) {
            temp = lastTransformer2.transform(temp);
            if (temp instanceof MuleMessage) {
                result = (MuleMessage)temp;
                continue;
            }
            result.setPayload(temp);
        }
        if (lastTransformer2 != null && lastTransformer2.getReturnClass().equals(MuleMessage.class)) {
            return result;
        }
        return result.getPayload();
    }

    @Override
    public void initialise() throws InitialisationException {
        for (Transformer transformer : this.transformers) {
            transformer.initialise();
        }
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        for (Transformer transformer : this.transformers) {
            transformer.setMuleContext(muleContext);
        }
    }

    @Override
    public void setEndpoint(ImmutableEndpoint endpoint) {
        super.setEndpoint(endpoint);
        for (Transformer transformer : this.transformers) {
            transformer.setEndpoint(endpoint);
        }
    }

    @Override
    protected String generateTransformerName() {
        String name = this.transformers.get(0).getClass().getSimpleName();
        int i = name.indexOf("To");
        DataType<?> dt = this.transformers.get(this.transformers.size() - 1).getReturnDataType();
        if (i > 0 && dt != null) {
            String target = dt.getType().getSimpleName();
            if (target.equals("byte[]")) {
                target = "byteArray";
            }
            name = name.substring(0, i + 2) + StringUtils.capitalize((String)target);
        }
        return name;
    }
}

