/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.codec;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.XMLEntityCodec;

public class XmlEntityEncoder
extends AbstractTransformer {
    public XmlEntityEncoder() {
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
        this.setReturnDataType((DataType)DataTypeFactory.TEXT_STRING);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            String data = src instanceof byte[] ? new String((byte[])src, encoding) : (src instanceof InputStream ? IOUtils.toString((InputStream)((InputStream)src)) : (String)src);
            return XMLEntityCodec.encodeString(data);
        }
        catch (Exception ex) {
            throw new TransformerException(CoreMessages.transformFailed(src.getClass().getName(), "XML"), this, (Throwable)ex);
        }
    }
}

