/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.encryption;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.mule.api.EncryptionStrategy;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.CryptoFailureException;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.IOUtils;

public abstract class AbstractEncryptionTransformer
extends AbstractTransformer {
    private EncryptionStrategy strategy = null;
    private String strategyName = null;

    public AbstractEncryptionTransformer() {
        this.registerSourceType(byte[].class);
        this.registerSourceType(String.class);
        this.registerSourceType(InputStream.class);
        this.setReturnClass((Class)byte[].class);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractEncryptionTransformer clone = (AbstractEncryptionTransformer)super.clone();
        clone.setStrategy(this.strategy);
        clone.setStrategyName(this.strategyName);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTransform(Object src, String encoding) throws TransformerException {
        byte[] buf;
        block11: {
            if (src instanceof String) {
                buf = src.toString().getBytes();
            } else {
                if (src instanceof InputStream) {
                    InputStream input = (InputStream)src;
                    try {
                        buf = IOUtils.toByteArray(input);
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        IOUtils.closeQuietly((InputStream)input);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)input);
                    {
                        break block11;
                    }
                }
                buf = (byte[])src;
            }
        }
        try {
            byte[] result = this.getTransformedBytes(buf);
            if (this.getReturnClass().equals(String.class)) {
                if (encoding != null) {
                    try {
                        return new String(result, encoding);
                    }
                    catch (UnsupportedEncodingException ex) {
                        return new String(result);
                    }
                }
                return new String(result);
            }
            return result;
        }
        catch (CryptoFailureException e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    protected abstract byte[] getTransformedBytes(byte[] var1) throws CryptoFailureException;

    public void initialise() throws InitialisationException {
        if (this.strategyName != null) {
            if (this.endpoint.getMuleContext().getSecurityManager() == null) {
                if (this.strategy == null) {
                    throw new InitialisationException(CoreMessages.authSecurityManagerNotSet(), (Initialisable)this);
                }
            } else {
                this.strategy = this.endpoint.getMuleContext().getSecurityManager().getEncryptionStrategy(this.strategyName);
            }
        }
        if (this.strategy == null) {
            throw new InitialisationException(CoreMessages.encryptionStrategyNotSet(), (Initialisable)this);
        }
    }

    public EncryptionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(EncryptionStrategy strategy) {
        this.strategy = strategy;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }
}

