/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.Collections;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleRuntimeException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.PropertyScope;
import org.mule.api.transport.UniqueIdNotSupportedException;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.MessagePropertiesContext;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.mule.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageAdapter
implements MessageAdapter,
ThreadSafeAccess {
    protected static transient Log logger;
    protected MessagePropertiesContext properties = new MessagePropertiesContext();
    protected ConcurrentMap attachments = new ConcurrentHashMap();
    protected ExceptionPayload exceptionPayload;
    protected String id = UUID.getUUID();
    private transient AtomicReference ownerThread = null;
    private transient AtomicBoolean mutable = null;

    protected AbstractMessageAdapter() {
        logger = LogFactory.getLog(this.getClass());
    }

    protected AbstractMessageAdapter(MessageAdapter template) {
        logger = LogFactory.getLog(this.getClass());
        if (null != template) {
            this.properties = template instanceof AbstractMessageAdapter ? ((AbstractMessageAdapter)template).getPropertiesContext() : ((AbstractMessageAdapter)((DefaultMuleMessage)template).getAdapter()).getPropertiesContext();
            for (String key : template.getAttachmentNames()) {
                try {
                    this.addAttachment(key, template.getAttachment(key));
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToReadPayload(), (Throwable)e);
                }
            }
            this.exceptionPayload = template.getExceptionPayload();
            try {
                this.id = template.getUniqueId();
            }
            catch (UniqueIdNotSupportedException uniqueIdNotSupportedException) {
                // empty catch block
            }
        }
    }

    MessagePropertiesContext getPropertiesContext() {
        return this.properties.copy();
    }

    public String toString() {
        this.assertAccess(false);
        StringBuffer buf = new StringBuffer(120);
        buf.append(this.getClass().getName());
        buf.append("/" + super.toString());
        buf.append('{');
        buf.append("id=").append(this.getUniqueId());
        buf.append(", payload=").append(this.getPayload().getClass().getName());
        buf.append(", properties=").append(this.properties);
        buf.append(", correlationId=").append(this.getCorrelationId());
        buf.append(", correlationGroup=").append(this.getCorrelationGroupSize());
        buf.append(", correlationSeq=").append(this.getCorrelationSequence());
        buf.append(", encoding=").append(this.getEncoding());
        buf.append(", exceptionPayload=").append(this.exceptionPayload);
        if (logger.isDebugEnabled()) {
            buf.append(", properties=").append(this.properties);
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public void addProperties(Map<String, Object> props) {
        this.addProperties(props, this.properties.getDefaultScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProperties(Map<String, Object> props, PropertyScope scope) {
        this.assertAccess(true);
        if (props != null) {
            Map<String, Object> map = props;
            synchronized (map) {
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    this.setProperty(entry.getKey(), entry.getValue(), scope);
                }
            }
        }
    }

    protected void addInboundProperties(Map props) {
        this.properties.addInboundProperties(props);
    }

    @Override
    public void clearProperties() {
        this.assertAccess(true);
        this.properties.clearProperties();
    }

    @Override
    public Object removeProperty(String key) {
        this.assertAccess(true);
        return this.properties.removeProperty(key);
    }

    @Override
    public Object removeProperty(String key, PropertyScope scope) {
        this.assertAccess(true);
        return this.properties.removeProperty(key, scope);
    }

    @Override
    public Object getProperty(String key) {
        this.assertAccess(false);
        return this.properties.getProperty(key);
    }

    @Override
    public Set<String> getPropertyNames() {
        this.assertAccess(false);
        return this.properties.getPropertyNames();
    }

    @Override
    public Set<String> getPropertyNames(PropertyScope scope) {
        this.assertAccess(false);
        return this.properties.getScopedProperties(scope).keySet();
    }

    @Override
    public void setProperty(String key, Object value) {
        this.assertAccess(true);
        if (key != null) {
            if (value != null) {
                this.properties.setProperty(key, value);
            } else {
                logger.warn((Object)("setProperty(key, value) called with null value; removing key: " + key + "; please report the following stack trace to " + MuleManifest.getDevListEmail()), new Throwable());
                this.properties.removeProperty(key);
            }
        } else {
            logger.warn((Object)("setProperty(key, value) ignored because of null key for object: " + value + "; please report the following stack trace to " + MuleManifest.getDevListEmail()), new Throwable());
        }
    }

    @Override
    public void setProperty(String key, Object value, PropertyScope scope) {
        this.assertAccess(true);
        if (key != null) {
            if (value != null) {
                this.properties.setProperty(key, value, scope);
            } else {
                logger.warn((Object)("setProperty(key, value) called with null value; removing key: " + key + "; please report the following stack trace to " + MuleManifest.getDevListEmail()), new Throwable());
                this.properties.removeProperty(key);
            }
        } else {
            logger.warn((Object)("setProperty(key, value) ignored because of null key for object: " + value + "; please report the following stack trace to " + MuleManifest.getDevListEmail()), new Throwable());
        }
    }

    @Override
    public String getUniqueId() {
        this.assertAccess(false);
        return this.id;
    }

    @Override
    public Object getProperty(String name, Object defaultValue) {
        this.assertAccess(false);
        return this.properties.getProperty(name, defaultValue);
    }

    @Override
    public Object getProperty(String name, PropertyScope scope) {
        this.assertAccess(false);
        return this.properties.getProperty(name, scope);
    }

    @Override
    public int getIntProperty(String name, int defaultValue) {
        this.assertAccess(false);
        return this.properties.getIntProperty(name, defaultValue);
    }

    @Override
    public long getLongProperty(String name, long defaultValue) {
        this.assertAccess(false);
        return this.properties.getLongProperty(name, defaultValue);
    }

    @Override
    public double getDoubleProperty(String name, double defaultValue) {
        this.assertAccess(false);
        return this.properties.getDoubleProperty(name, defaultValue);
    }

    @Override
    public boolean getBooleanProperty(String name, boolean defaultValue) {
        this.assertAccess(false);
        return this.properties.getBooleanProperty(name, defaultValue);
    }

    @Override
    public String getStringProperty(String name, String defaultValue) {
        this.assertAccess(false);
        return this.properties.getStringProperty(name, defaultValue);
    }

    @Override
    public void setBooleanProperty(String name, boolean value) {
        this.assertAccess(true);
        this.setProperty(name, value);
    }

    @Override
    public void setIntProperty(String name, int value) {
        this.assertAccess(true);
        this.setProperty(name, new Integer(value));
    }

    @Override
    public void setLongProperty(String name, long value) {
        this.assertAccess(true);
        this.setProperty(name, new Long(value));
    }

    @Override
    public void setDoubleProperty(String name, double value) {
        this.assertAccess(true);
        this.setProperty(name, new Double(value));
    }

    @Override
    public void setStringProperty(String name, String value) {
        this.assertAccess(true);
        this.setProperty(name, value);
    }

    @Override
    public Object getReplyTo() {
        this.assertAccess(false);
        return this.getProperty("MULE_REPLYTO");
    }

    @Override
    public void setReplyTo(Object replyTo) {
        this.assertAccess(true);
        if (replyTo != null) {
            this.setProperty("MULE_REPLYTO", replyTo);
        } else {
            this.removeProperty("MULE_REPLYTO");
        }
    }

    @Override
    public String getCorrelationId() {
        this.assertAccess(false);
        return (String)this.getProperty("MULE_CORRELATION_ID");
    }

    @Override
    public void setCorrelationId(String correlationId) {
        this.assertAccess(true);
        if (StringUtils.isNotBlank((String)correlationId)) {
            this.setProperty("MULE_CORRELATION_ID", correlationId);
        } else {
            this.removeProperty("MULE_CORRELATION_ID");
        }
    }

    @Override
    public int getCorrelationSequence() {
        this.assertAccess(false);
        return this.getIntProperty("MULE_CORRELATION_SEQUENCE", -1);
    }

    @Override
    public void setCorrelationSequence(int sequence) {
        this.assertAccess(true);
        this.setIntProperty("MULE_CORRELATION_SEQUENCE", sequence);
    }

    @Override
    public int getCorrelationGroupSize() {
        this.assertAccess(false);
        return this.getIntProperty("MULE_CORRELATION_GROUP_SIZE", -1);
    }

    @Override
    public void setCorrelationGroupSize(int size) {
        this.assertAccess(true);
        this.setIntProperty("MULE_CORRELATION_GROUP_SIZE", size);
    }

    @Override
    public ExceptionPayload getExceptionPayload() {
        this.assertAccess(false);
        return this.exceptionPayload;
    }

    @Override
    public void setExceptionPayload(ExceptionPayload payload) {
        this.assertAccess(true);
        this.exceptionPayload = payload;
    }

    @Override
    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        this.assertAccess(true);
        this.attachments.put((Object)name, (Object)dataHandler);
    }

    @Override
    public void removeAttachment(String name) throws Exception {
        this.assertAccess(true);
        this.attachments.remove((Object)name);
    }

    @Override
    public DataHandler getAttachment(String name) {
        this.assertAccess(false);
        return (DataHandler)this.attachments.get((Object)name);
    }

    @Override
    public Set<String> getAttachmentNames() {
        this.assertAccess(false);
        return Collections.unmodifiableSet((Set)this.attachments.keySet());
    }

    @Override
    public String getEncoding() {
        this.assertAccess(false);
        String encoding = this.getStringProperty("MULE_ENCODING", null);
        if (encoding != null) {
            return encoding;
        }
        return System.getProperty("mule.encoding");
    }

    @Override
    public void setEncoding(String encoding) {
        this.assertAccess(true);
        this.setStringProperty("MULE_ENCODING", encoding);
    }

    @Override
    public void release() {
        if (this.getPayload() instanceof InputStream) {
            IOUtils.closeQuietly((InputStream)((InputStream)this.getPayload()));
        }
        this.properties.clearProperties();
        this.attachments.clear();
    }

    @Override
    public void assertAccess(boolean write) {
        if (ThreadSafeAccess.AccessControl.isAssertMessageAccess()) {
            this.initAccessControl();
            this.setOwner();
            this.checkMutable(write);
        }
    }

    private void setOwner() {
        if (null == this.ownerThread.get()) {
            this.ownerThread.compareAndSet(null, (Object)Thread.currentThread());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkMutable(boolean write) {
        Thread currentThread = Thread.currentThread();
        if (currentThread.equals(this.ownerThread.get())) {
            if (!write || this.mutable.get()) return;
            if (!this.isDisabled()) throw this.newException("Cannot write to immutable message");
            logger.warn((Object)"Writing to immutable message (exception disabled)");
            return;
        } else {
            if (!write) return;
            if (!this.isDisabled()) throw this.newException("Only owner thread can write to message: " + this.ownerThread.get() + "/" + Thread.currentThread());
            logger.warn((Object)"Non-owner writing to message (exception disabled)");
        }
    }

    protected IllegalStateException newException(String message) {
        IllegalStateException exception = new IllegalStateException(message);
        logger.warn((Object)"Message access violation", (Throwable)exception);
        return exception;
    }

    protected boolean isDisabled() {
        return !ThreadSafeAccess.AccessControl.isFailOnMessageScribbling();
    }

    private synchronized void initAccessControl() {
        if (null == this.ownerThread) {
            this.ownerThread = new AtomicReference();
        }
        if (null == this.mutable) {
            this.mutable = new AtomicBoolean(true);
        }
    }

    @Override
    public synchronized void resetAccessControl() {
        if (this.ownerThread != null) {
            this.ownerThread.set(null);
        }
        if (this.mutable != null) {
            this.mutable.set(true);
        }
    }

    @Override
    public ThreadSafeAccess newThreadCopy() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"The newThreadCopy method in AbstractMessageAdapter is being used directly. This code may be susceptible to 'scribbling' issues with messages. Please consider implementing the ThreadSafeAccess interface in the message adapter.");
        }
        return this;
    }
}

