/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.mule.RequestContext;
import org.mule.api.MuleSession;
import org.mule.api.transport.PropertyScope;
import org.mule.util.CaseInsensitiveHashMap;
import org.mule.util.MapUtils;
import org.mule.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePropertiesContext
implements Serializable {
    private static final long serialVersionUID = -5230693402768953742L;
    private static final List<PropertyScope> SCOPE_ORDER = new ArrayList<PropertyScope>();
    protected Map<PropertyScope, Map<String, Object>> scopedMap;
    protected Set<String> keySet;
    protected PropertyScope defaultScope = PropertyScope.OUTBOUND;

    public MessagePropertiesContext() {
        this.keySet = new TreeSet<String>();
        this.scopedMap = new TreeMap<PropertyScope, Map<String, Object>>(new PropertyScope.ScopeComparator());
        this.scopedMap.put(PropertyScope.INVOCATION, (Map<String, Object>)((Object)new CaseInsensitiveHashMap(6)));
        this.scopedMap.put(PropertyScope.INBOUND, (Map<String, Object>)((Object)new CaseInsensitiveHashMap(6)));
        this.scopedMap.put(PropertyScope.OUTBOUND, (Map<String, Object>)((Object)new CaseInsensitiveHashMap(6)));
    }

    private MessagePropertiesContext(PropertyScope defaultScope, Set<String> keySet, Map<PropertyScope, Map<String, Object>> scopedMap) {
        this.keySet = keySet;
        this.scopedMap = scopedMap;
        this.defaultScope = defaultScope;
    }

    protected Map<String, Object> getScopedProperties(PropertyScope scope) {
        Map<String, Object> map = this.scopedMap.get(scope);
        if (map == null) {
            map = null;
            throw new IllegalArgumentException("Scope not registered: " + scope);
        }
        return map;
    }

    public PropertyScope getDefaultScope() {
        return this.defaultScope;
    }

    protected void addInboundProperties(Map<String, Object> properties) {
        if (properties != null) {
            HashMap<String, Object> props = new HashMap<String, Object>(properties.size());
            for (String key : properties.keySet()) {
                props.put(key, properties.get(key));
            }
            this.getScopedProperties(PropertyScope.INBOUND).putAll(props);
            this.keySet.addAll(props.keySet());
        }
    }

    public Object getProperty(String key) {
        Object value = null;
        for (PropertyScope scope : SCOPE_ORDER) {
            if (PropertyScope.SESSION.equals(scope)) {
                if (RequestContext.getEvent() != null) {
                    value = RequestContext.getEvent().getSession().getProperty(key);
                }
            } else {
                value = this.scopedMap.get(scope).get(key);
            }
            if (value == null) continue;
            break;
        }
        return value;
    }

    public Object getProperty(String key, PropertyScope scope) {
        if (scope == null) {
            return this.getProperty(key);
        }
        Object value = null;
        if (PropertyScope.SESSION.equals(scope)) {
            if (RequestContext.getEvent() != null) {
                value = RequestContext.getEvent().getSession().getProperty(key);
            }
        } else {
            value = this.scopedMap.get(scope).get(key);
        }
        return value;
    }

    public void clearProperties() {
        Map<String, Object> props = this.getScopedProperties(PropertyScope.INVOCATION);
        this.keySet.removeAll(props.keySet());
        props.clear();
        props = this.getScopedProperties(PropertyScope.OUTBOUND);
        this.keySet.removeAll(props.keySet());
        props.clear();
    }

    public void clearProperties(PropertyScope scope) {
        if (scope == null) {
            this.clearProperties();
            return;
        }
        this.checkScopeForWriteAccess(scope);
        if (PropertyScope.SESSION.equals(scope)) {
            if (RequestContext.getEvent() != null) {
                MuleSession session = RequestContext.getEvent().getSession();
                for (Object key : session.getPropertyNamesAsSet()) {
                    session.removeProperty(key);
                }
            }
        } else {
            Map<String, Object> props = this.getScopedProperties(scope);
            this.keySet.removeAll(props.keySet());
            props.clear();
        }
    }

    public Object removeProperty(String key) {
        Object value = this.getScopedProperties(PropertyScope.OUTBOUND).remove(key);
        Object inv = this.getScopedProperties(PropertyScope.INVOCATION).remove(key);
        this.keySet.remove(key);
        if (value == null) {
            value = inv;
        }
        return value;
    }

    public Object removeProperty(String key, PropertyScope scope) {
        if (scope == null) {
            return this.removeProperty(key);
        }
        Object value = null;
        if (PropertyScope.SESSION.equals(scope)) {
            if (RequestContext.getEvent() != null) {
                value = RequestContext.getEvent().getSession().removeProperty(key);
            }
        } else {
            value = this.getScopedProperties(scope).remove(key);
        }
        if (this.getProperty(key, PropertyScope.OUTBOUND) == null && this.getProperty(key, PropertyScope.INVOCATION) == null && this.getProperty(key, PropertyScope.INBOUND) == null) {
            this.keySet.remove(key);
        }
        return value;
    }

    public void setProperty(String key, Object value) {
        this.getScopedProperties(this.defaultScope).put(key, value);
        this.keySet.add(key);
    }

    public void setProperty(String key, Object value, PropertyScope scope) {
        if (scope == null) {
            this.setProperty(key, value);
            return;
        }
        this.checkScopeForWriteAccess(scope);
        if (PropertyScope.SESSION.equals(scope)) {
            if (RequestContext.getEvent() != null) {
                RequestContext.getEvent().getSession().setProperty(key, value);
            }
        } else {
            this.getScopedProperties(scope).put(key, value);
            this.keySet.add(key);
        }
    }

    public Set<String> getPropertyNames() {
        HashSet<String> allProps = new HashSet<String>();
        allProps.addAll(this.keySet);
        if (RequestContext.getEvent() != null) {
            allProps.addAll(RequestContext.getEvent().getSession().getPropertyNamesAsSet());
        }
        return allProps;
    }

    public Set<String> getPropertyNames(PropertyScope scope) {
        if (scope == null) {
            return this.getPropertyNames();
        }
        if (PropertyScope.SESSION.equals(scope)) {
            if (RequestContext.getEvent() != null) {
                return RequestContext.getEvent().getSession().getPropertyNamesAsSet();
            }
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.getScopedProperties(scope).keySet());
    }

    protected void checkScopeForWriteAccess(PropertyScope scope) {
        if (scope == null || PropertyScope.INBOUND.equals(scope)) {
            throw new IllegalArgumentException("Scope is invalid for writing properties: " + scope);
        }
    }

    public Object getProperty(String key, Object defaultValue) {
        Object value = this.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public byte getByteProperty(String name, byte defaultValue) {
        return ObjectUtils.getByte(this.getProperty(name), defaultValue);
    }

    public short getShortProperty(String name, short defaultValue) {
        return ObjectUtils.getShort(this.getProperty(name), defaultValue);
    }

    public int getIntProperty(String name, int defaultValue) {
        return ObjectUtils.getInt(this.getProperty(name), defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return ObjectUtils.getLong(this.getProperty(name), defaultValue);
    }

    public float getFloatProperty(String name, float defaultValue) {
        return ObjectUtils.getFloat(this.getProperty(name), defaultValue);
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return ObjectUtils.getDouble(this.getProperty(name), defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return ObjectUtils.getBoolean(this.getProperty(name), defaultValue);
    }

    public String getStringProperty(String name, String defaultValue) {
        return ObjectUtils.getString(this.getProperty(name), defaultValue);
    }

    protected MessagePropertiesContext copy() {
        TreeSet<String> keys = new TreeSet<String>(this.getPropertyNames());
        TreeMap<PropertyScope, Map<String, Object>> map = new TreeMap<PropertyScope, Map<String, Object>>(new PropertyScope.ScopeComparator());
        map.put(PropertyScope.INVOCATION, (Map<String, Object>)((Object)new CaseInsensitiveHashMap(this.getScopedProperties(PropertyScope.INVOCATION))));
        map.put(PropertyScope.INBOUND, (Map<String, Object>)((Object)new CaseInsensitiveHashMap(this.getScopedProperties(PropertyScope.INBOUND))));
        map.put(PropertyScope.OUTBOUND, (Map<String, Object>)((Object)new CaseInsensitiveHashMap(this.getScopedProperties(PropertyScope.OUTBOUND))));
        return new MessagePropertiesContext(this.getDefaultScope(), keys, map);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("Properties{");
        for (Map.Entry<PropertyScope, Map<String, Object>> entry : this.scopedMap.entrySet()) {
            buf.append(entry.getKey()).append(":");
            buf.append(MapUtils.toString(entry.getValue(), false));
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    static {
        SCOPE_ORDER.add(PropertyScope.OUTBOUND);
        SCOPE_ORDER.add(PropertyScope.INVOCATION);
        SCOPE_ORDER.add(PropertyScope.INBOUND);
        SCOPE_ORDER.add(PropertyScope.SESSION);
    }
}

