/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    public static String elementToString(Element e) {
        StringBuffer buf = new StringBuffer();
        buf.append(e.getTagName()).append("{");
        for (int i = 0; i < e.getAttributes().getLength(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            Node n = e.getAttributes().item(i);
            buf.append(XMLUtils.attributeName((Attr)n)).append("=").append(n.getNodeValue());
        }
        buf.append("}");
        return buf.toString();
    }

    public static boolean isLocalName(Element element, String name) {
        return element.getLocalName().equals(name);
    }

    public static String attributeName(Attr attribute) {
        String name = attribute.getLocalName();
        if (null == name) {
            name = attribute.getName();
        }
        return name;
    }

    public static String getTextChild(Element element) {
        NodeList children = element.getChildNodes();
        String value = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            if (null != value) {
                throw new IllegalStateException("Element " + XMLUtils.elementToString(element) + " has more than one text child.");
            }
            value = child.getNodeValue();
        }
        return value;
    }
}

