/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import java.util.ArrayList;
import org.jbpm.pvm.internal.email.impl.AddressFilter;
import org.jbpm.pvm.internal.email.impl.MailServer;
import org.jbpm.pvm.internal.email.impl.MailSessionImpl;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.binding.ObjectBinding;
import org.jbpm.pvm.internal.wire.binding.PropertiesBinding;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.ListDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.PatternDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class MailSessionBinding
extends WireDescriptorBinding {
    private static final PropertiesBinding propertiesBinding = new PropertiesBinding();
    private static final ObjectBinding objectBinding = new ObjectBinding();

    public MailSessionBinding() {
        super("mail-session");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        ArrayList<Descriptor> serverDescriptors = new ArrayList<Descriptor>();
        for (Element serverElement : XmlUtil.elements(element, "mail-server")) {
            Element authenticatorElement;
            Element propertiesElement;
            ObjectDescriptor serverDescriptor = new ObjectDescriptor(MailServer.class);
            serverDescriptors.add(serverDescriptor);
            Element filterElement = XmlUtil.element(serverElement, "address-filter");
            if (filterElement != null) {
                ArrayList<Descriptor> includeDescriptors = new ArrayList<Descriptor>();
                for (Element includeElement : XmlUtil.elements(filterElement, "include")) {
                    includeDescriptors.add(this.parsePattern(includeElement, parse, parser));
                }
                ListDescriptor includesDescriptor = new ListDescriptor();
                includesDescriptor.setValueDescriptors(includeDescriptors);
                ArrayList<Descriptor> excludeDescriptors = new ArrayList<Descriptor>();
                for (Element excludeElement : XmlUtil.elements(filterElement, "exclude")) {
                    excludeDescriptors.add(this.parsePattern(excludeElement, parse, parser));
                }
                ListDescriptor excludesDescriptor = new ListDescriptor();
                excludesDescriptor.setValueDescriptors(excludeDescriptors);
                ObjectDescriptor filterDescriptor = new ObjectDescriptor(AddressFilter.class);
                filterDescriptor.addInjection("includePatterns", includesDescriptor);
                filterDescriptor.addInjection("excludePatterns", excludesDescriptor);
                serverDescriptor.addInjection("addressFilter", filterDescriptor);
            }
            if ((propertiesElement = XmlUtil.element(serverElement, "session-properties")) != null) {
                Descriptor propertiesDescriptor = (Descriptor)propertiesBinding.parse(propertiesElement, parse, parser);
                serverDescriptor.addInjection("sessionProperties", propertiesDescriptor);
            } else {
                parse.addProblem("missing mail session properties", element);
            }
            if ((authenticatorElement = XmlUtil.element(serverElement, "authenticator")) == null) continue;
            Descriptor authenticatorDescriptor = (Descriptor)objectBinding.parse(authenticatorElement, parse, parser);
            serverDescriptor.addInjection("authenticator", authenticatorDescriptor);
        }
        ListDescriptor serversDescriptor = new ListDescriptor();
        serversDescriptor.setValueDescriptors(serverDescriptors);
        ObjectDescriptor sessionDescriptor = new ObjectDescriptor(MailSessionImpl.class);
        sessionDescriptor.addInjection("mailServers", serversDescriptor);
        return sessionDescriptor;
    }

    protected Descriptor parsePattern(Element patternElement, Parse parse, Parser parser) {
        Boolean canonEq;
        String canonEqAttr;
        Boolean literal;
        PatternDescriptor patternDescriptor = new PatternDescriptor(XmlUtil.getContentText(patternElement));
        String literalAttr = XmlUtil.attribute(patternElement, "literal");
        if (literalAttr != null && (literal = XmlUtil.parseBooleanValue(literalAttr)) != null) {
            patternDescriptor.setLiteral(literal);
        }
        if ((canonEqAttr = XmlUtil.attribute(patternElement, "canonEq")) != null && (canonEq = XmlUtil.parseBooleanValue(canonEqAttr)) != null) {
            patternDescriptor.setCanonEq(canonEq);
        }
        return patternDescriptor;
    }
}

