/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import org.jbpm.pvm.internal.jms.JmsMessageSession;
import org.jbpm.pvm.internal.jobexecutor.JobExecutorMessageSession;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.ContextTypeRefDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.JndiDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.TransactionRefDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class MessageSessionBinding
extends WireDescriptorBinding {
    public MessageSessionBinding() {
        super("message-session");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        ObjectDescriptor objectDescriptor = new ObjectDescriptor();
        String target = XmlUtil.attribute(element, "target");
        if ("jms".equals(target)) {
            JndiDescriptor jndiDescriptor;
            objectDescriptor.setClassName(JmsMessageSession.class.getName());
            objectDescriptor.addInjection("dbSession", new ContextTypeRefDescriptor(DbSession.class));
            if (element.hasAttribute("session-jndi")) {
                String jmsSessionJndiName = element.getAttribute("session-jndi");
                jndiDescriptor = new JndiDescriptor(jmsSessionJndiName);
                objectDescriptor.addInjection("jmsSession", jndiDescriptor);
            } else {
                parse.addProblem("attribute <" + XmlUtil.getTagLocalName(element) + " session-jndi=\"...\" is required when target=\"jms\"", element);
            }
            if (element.hasAttribute("destination-jndi")) {
                String jmsDestinationJndiName = element.getAttribute("destination-jndi");
                jndiDescriptor = new JndiDescriptor(jmsDestinationJndiName);
                objectDescriptor.addInjection("jmsDestination", jndiDescriptor);
            } else {
                parse.addProblem("attribute <" + XmlUtil.getTagLocalName(element) + " destination-jndi=\"...\" is required when target=\"jms\"", element);
            }
        } else {
            objectDescriptor.setClassName(JobExecutorMessageSession.class.getName());
            objectDescriptor.addInjection("transaction", new TransactionRefDescriptor());
            objectDescriptor.addInjection("dbSession", new ContextTypeRefDescriptor(DbSession.class));
        }
        return objectDescriptor;
    }
}

