/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.PoolingProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.annotations.ObjectScope;
import org.mule.object.AbstractObjectFactory;
import org.mule.object.PrototypeObjectFactory;
import org.mule.object.SingletonObjectFactory;

public class ScopedObjectFactory
extends AbstractObjectFactory {
    private ObjectScope scope = ObjectScope.SINGLETON;
    private PoolingProfile poolingProfile;
    private AbstractObjectFactory delegate;
    private Object objectInstance;

    public ObjectScope getScope() {
        return this.scope;
    }

    public void setScope(ObjectScope scope) {
        this.scope = scope;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void initialise() throws InitialisationException {
        if (this.scope == ObjectScope.REQUEST) {
            this.delegate = new PrototypeObjectFactory();
        } else if (this.scope == ObjectScope.SINGLETON) {
            this.delegate = new SingletonObjectFactory();
        } else if (this.scope == ObjectScope.POOLED) {
            this.delegate = new PrototypeObjectFactory();
        } else {
            throw new InitialisationException(CoreMessages.valueIsInvalidFor(String.valueOf((Object)this.scope), "scope"), (Initialisable)this);
        }
        this.delegate.setProperties(this.getProperties());
        this.delegate.setObjectClass(this.getObjectClass());
        this.delegate.initialise();
    }

    public void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    public boolean isSingleton() {
        return this.scope == ObjectScope.SINGLETON;
    }

    public Object getObjectInstance() {
        return this.objectInstance;
    }

    public void setObjectInstance(Object instance) {
        if (!this.isSingleton()) {
            throw new UnsupportedOperationException("cannot set the instance on a non-singleton");
        }
        this.objectInstance = instance;
        this.setObjectClass(instance.getClass());
    }

    public Object getInstance() throws Exception {
        if (this.objectInstance != null) {
            return this.objectInstance;
        }
        return super.getInstance();
    }

    public boolean isAutoWireObject() {
        return true;
    }
}

