/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.annotations.processors;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleRuntimeException;
import org.mule.config.annotations.endpoints.Bind;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.annotations.processors.AbstractAnnotationProcessor;
import org.mule.impl.endpoint.AnnotatedEndpointData;
import org.mule.impl.endpoint.MEP;
import org.mule.routing.binding.DefaultInterfaceBinding;
import org.mule.util.StringUtils;

public class DirectBindAnnotationProcessor
extends AbstractAnnotationProcessor {
    protected final transient Log logger = LogFactory.getLog(DirectBindAnnotationProcessor.class);

    public Object process(Object object) {
        try {
            Field[] fields;
            try {
                fields = object.getClass().getDeclaredFields();
            }
            catch (NoClassDefFoundError e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn((Object)e.toString());
                }
                return object;
            }
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.isAnnotationPresent(Bind.class)) continue;
                Bind binding = field.getAnnotation(Bind.class);
                AnnotatedEndpointData epd = new AnnotatedEndpointData(MEP.OutIn, binding);
                epd.setConnectorName(binding.connector());
                epd.setAddress(binding.uri());
                DefaultInterfaceBinding router = new DefaultInterfaceBinding();
                router.setInterface(field.getType());
                if (!StringUtils.isBlank((String)binding.method())) {
                    router.setMethod(this.getValue(binding.method()));
                    for (int j = 0; j < object.getClass().getMethods().length; ++j) {
                        Method m = object.getClass().getMethods()[j];
                        if (!m.getName().equals(router.getMethod())) continue;
                        epd.setMEPUsingMethod(m, false);
                        break;
                    }
                }
                router.setEndpoint(this.helper.processEndpoint(epd));
                field.setAccessible(true);
                field.set(object, router.createProxy(object));
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage("Failed to process @Bind annotation"), (Throwable)e);
        }
        return object;
    }
}

