/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.resolvers;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.proxy.Enhancer;
import org.mule.api.MuleContext;
import org.mule.api.MuleEventContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.InvocationResult;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.annotations.Entrypoint;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.transformers.ExpressionTransformer;
import org.mule.model.resolvers.AbstractEntryPointResolver;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;
import org.mule.utils.AnnotationUtils;

public class AnnotatedEntryPointResolver
extends AbstractEntryPointResolver
implements MuleContextAware {
    private Set<String> ignoredMethods = new HashSet<String>(Arrays.asList("equals", "getInvocationHandler", "set*", "toString", "getClass", "notify", "notifyAll", "wait", "hashCode", "clone", "is*", "get*"));
    private volatile boolean firstTime = true;
    private Map<Method, Transformer> transformerCache = new ConcurrentHashMap();
    protected MuleContext muleContext;

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public InvocationResult invoke(Object component, MuleEventContext context) throws Exception {
        Object[] payload;
        Method method;
        String methodName;
        if (this.firstTime) {
            try {
                this.initCache(component, context);
            }
            catch (Exception e) {
                InvocationResult result = new InvocationResult(0);
                result.setErrorMessage(e.toString());
                return result;
            }
        }
        if ((methodName = (String)context.getMessage().removeProperty("method")) != null) {
            method = this.getMethodByName(methodName, component);
            if (method == null) {
                throw new IllegalArgumentException("Method not found: " + methodName + " on object: " + component.getClass() + ". If the component is a proxy there needs to be an interface on the proxy that defines this method");
            }
            payload = this.getPayloadForMethod(method, component, context);
        } else if (this.methodCache.size() == 1) {
            method = (Method)this.methodCache.values().iterator().next();
            payload = this.getPayloadForMethod(method, component, context);
        } else {
            payload = this.getPayloadFromMessage(context);
            method = this.getMethodByArguments(component, payload);
            if (method == null) {
                InvocationResult result = new InvocationResult(0);
                result.setErrorMessage("@Entrypoint annotation not set on any methods of the service component: " + component);
                return result;
            }
        }
        return this.invokeMethod(component, method, method.getParameterTypes().length == 0 ? ClassUtils.NO_ARGS : payload);
    }

    protected Object[] getPayloadForMethod(Method method, Object component, MuleEventContext context) throws TransformerException, InitialisationException {
        Object[] payload;
        Method m = method;
        if (Enhancer.isEnhanced(component.getClass())) {
            try {
                m = component.getClass().getSuperclass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new TransformerException(CoreMessages.createStaticMessage(e.getMessage()), (Throwable)e);
            }
        }
        if (AnnotationUtils.methodHasParamAnnotations(m)) {
            payload = this.getPayloadFromMessageWithAnnotations(m, context);
        } else {
            payload = this.getPayloadFromMessage(context);
            List methods = ClassUtils.getSatisfiableMethods(component.getClass(), ClassUtils.getClassTypes(payload), true, true, this.ignoredMethods);
            if (methods.size() == 0 && m.getParameterTypes().length == 1) {
                Object temp = context.getMessage().getPayload(m.getParameterTypes()[0]);
                payload = new Object[]{temp};
            }
        }
        return payload;
    }

    protected Object[] getPayloadFromMessageWithAnnotations(Method method, MuleEventContext context) throws TransformerException, InitialisationException {
        Object o;
        ExpressionTransformer trans = (ExpressionTransformer)this.transformerCache.get(method);
        if (trans == null) {
            trans = AnnotationUtils.getTransformerForMethodWithAnnotations(method, this.muleContext);
            this.transformerCache.put(method, trans);
        }
        if ((o = trans.transform(context.getMessage())) instanceof NullPayload) {
            return new Object[]{null};
        }
        if (o.getClass().isArray()) {
            return (Object[])o;
        }
        return new Object[]{o};
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AnnotatedEntryPointResolver");
        sb.append("{transformFirst=").append(this.isTransformFirst());
        sb.append(", acceptVoidMethods=").append(this.isAcceptVoidMethods());
        sb.append('}');
        return sb.toString();
    }

    protected synchronized void initCache(Object component, MuleEventContext context) {
        for (int i = 0; i < component.getClass().getMethods().length; ++i) {
            Method method = component.getClass().getMethods()[i];
            if (!method.isAnnotationPresent(Entrypoint.class)) continue;
            this.addMethodByName(method, context);
        }
        this.firstTime = false;
    }

    protected Method getMethodByName(String name, Object object) {
        HashSet classes = new HashSet();
        Class<?> clazz = object.getClass();
        if (Proxy.isProxyClass(clazz)) {
            classes.addAll(Arrays.asList(clazz.getInterfaces()));
        } else {
            classes.add(object.getClass());
        }
        for (Class clazz2 : classes) {
            for (Method m : clazz2.getMethods()) {
                if (!m.getName().equals(name)) continue;
                return m;
            }
        }
        return null;
    }
}

