/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.registry;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.transport.Connector;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.service.TransportFactoryException;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.PropertiesUtils;

public class ConfigurableTransportFactory
extends TransportFactory {
    public static final String CHANNEL_OVERRIDES = "_configuredConnectorOverrides";
    public static final String CHANNEL_OVERRIDES_FILE = "META-INF/services/org/mule/config/channel-overrides.properties";
    public static final String SINGLETON_PROPERTY = "singleton";
    public static final String TRUE = "TRUE";
    private Properties overrides;

    public ConfigurableTransportFactory(MuleContext muleContext) throws MuleException {
        super(muleContext);
        this.overrides = (Properties)muleContext.getRegistry().lookupObject(CHANNEL_OVERRIDES);
        if (this.overrides == null) {
            this.overrides = this.loadOverrides();
            muleContext.getRegistry().registerObject(CHANNEL_OVERRIDES, this.overrides);
        }
    }

    public Connector createConnector(EndpointURI endpointURI) throws TransportFactoryException {
        Connector c;
        String scheme = endpointURI.getScheme();
        Map<Object, Object> temp = new Properties();
        PropertiesUtils.getPropertiesWithPrefix(this.overrides, scheme, temp);
        temp = PropertiesUtils.removeNamespaces(temp);
        String singleton = (String)temp.remove(SINGLETON_PROPERTY);
        if (TRUE.equalsIgnoreCase(singleton) && (c = this.getConnectorByProtocol(scheme)) != null) {
            return c;
        }
        c = super.createConnector(endpointURI);
        BeanUtils.populateWithoutFail(c, temp, true);
        return c;
    }

    protected Properties loadOverrides() throws MuleException {
        Properties props = new Properties();
        Enumeration<URL> e = ClassUtils.getResources(CHANNEL_OVERRIDES_FILE, this.getClass());
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            try {
                props.load(url.openStream());
            }
            catch (IOException e1) {
                throw new DefaultMuleException("failed to read channel overrides from URL: " + url.toExternalForm());
            }
        }
        return props;
    }
}

