/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.routing.RoutingException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.annotations.i18n.AnnotationsMessages;
import org.mule.routing.EventCorrelatorCallback;
import org.mule.routing.inbound.EventGroup;

public class SingleResponseWithCallbackCorrelator
implements EventCorrelatorCallback {
    protected final transient Log logger = LogFactory.getLog(SingleResponseWithCallbackCorrelator.class);
    protected String callback;

    public SingleResponseWithCallbackCorrelator(String callbackMethod) {
        this.callback = callbackMethod;
    }

    public boolean shouldAggregateEvents(EventGroup events) {
        if (events.expectedSize() > 1) {
            this.logger.warn((Object)"CorrelationGroup's expected size is not 1. The SingleResponseAggregator will only handle single replyTo events; if there will be multiple events for a single request,  use the 'ResponseCorrelationAggregator'");
        }
        return events.size() != 0;
    }

    public MuleMessage aggregateEvents(EventGroup events) throws RoutingException {
        MuleEvent event = events.iterator().next();
        if (this.callback != null) {
            event.getMessage().setProperty("method", this.callback, PropertyScope.INVOCATION);
            try {
                return event.getService().getComponent().invoke(event);
            }
            catch (MuleException e) {
                throw new RoutingException(AnnotationsMessages.failedToInvokeReplyMethod(this.callback), event.getMessage(), event.getEndpoint());
            }
        }
        return event.getMessage();
    }

    public EventGroup createEventGroup(MuleEvent event, Object id) {
        return new EventGroup(id);
    }
}

