/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.vm;

import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.transport.PollingReceiverWorker;
import org.mule.transport.TransactedPollingMessageReceiver;
import org.mule.transport.vm.VMConnector;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMMessageReceiver
extends TransactedPollingMessageReceiver {
    private VMConnector connector;
    private final Object lock = new Object();

    public VMMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, service, endpoint);
        this.setReceiveMessagesInTransaction(endpoint.getTransactionConfig().isTransacted());
        this.connector = (VMConnector)connector;
    }

    @Override
    protected void schedule() throws RejectedExecutionException, NullPointerException, IllegalArgumentException {
        if (!this.endpoint.isSynchronous()) {
            super.schedule();
        }
    }

    @Override
    protected void doDispose() {
    }

    @Override
    protected void doConnect() throws Exception {
        if (!this.endpoint.isSynchronous()) {
            QueueSession queueSession = this.connector.getQueueSession();
            Queue q = queueSession.getQueue(this.endpoint.getEndpointURI().getAddress());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Current queue depth for queue: " + this.endpoint.getEndpointURI().getAddress() + " is: " + q.size()));
            }
        }
    }

    @Override
    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(MuleMessage message) throws MuleException {
        DefaultMuleMessage newMessage = new DefaultMuleMessage(message.getPayload(), message, this.connector.getMuleContext());
        Object object = this.lock;
        synchronized (object) {
            this.routeMessage(newMessage);
        }
    }

    public Object onCall(MuleMessage message, boolean synchronous) throws MuleException {
        DefaultMuleMessage newMessage = new DefaultMuleMessage(message.getPayload(), message, this.connector.getMuleContext());
        return this.routeMessage((MuleMessage)newMessage, synchronous);
    }

    @Override
    protected List<MuleMessage> getMessages() throws Exception {
        if (this.isReceiveMessagesInTransaction()) {
            MuleEvent message = this.getFirstMessage();
            if (message == null) {
                return null;
            }
            ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>(1);
            messages.add(message.getMessage());
            return messages;
        }
        return this.getFirstMessages();
    }

    protected List<MuleMessage> getFirstMessages() throws Exception {
        QueueSession qs = this.connector.getQueueSession();
        Queue queue = qs.getQueue(this.endpoint.getEndpointURI().getAddress());
        LinkedList<MuleMessage> messages = new LinkedList<MuleMessage>();
        int maxThreads = this.connector.getReceiverThreadingProfile().getMaxThreadsActive();
        int batchSize = Math.max(1, Math.min(queue.size(), maxThreads / 2 - 1));
        MuleEvent message = (MuleEvent)queue.poll(this.connector.getQueueTimeout());
        if (message != null) {
            messages.add(message.getMessage());
            for (int i = 0; i < batchSize && message != null; ++i) {
                message = (MuleEvent)queue.poll(0L);
                if (message == null) continue;
                messages.add(message.getMessage());
            }
        }
        return messages;
    }

    protected MuleEvent getFirstMessage() throws Exception {
        QueueSession qs = this.connector.getQueueSession();
        Queue queue = qs.getQueue(this.endpoint.getEndpointURI().getAddress());
        return (MuleEvent)queue.poll(this.connector.getQueueTimeout());
    }

    @Override
    protected void processMessage(Object msg) throws Exception {
        MuleMessage message = (MuleMessage)msg;
        DefaultMuleMessage newMessage = new DefaultMuleMessage(message.getPayload(), message, this.connector.getMuleContext());
        this.routeMessage(newMessage);
    }

    @Override
    protected PollingReceiverWorker createWork() {
        return new VMReceiverWorker(this);
    }

    protected static class VMReceiverWorker
    extends PollingReceiverWorker {
        public VMReceiverWorker(VMMessageReceiver pollingMessageReceiver) {
            super(pollingMessageReceiver);
        }

        public void run() {
            while (this.getReceiver().isConnected()) {
                super.run();
            }
        }
    }
}

