/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.xmpp.XmppChatConversation;
import org.mule.transport.xmpp.XmppConversation;
import org.mule.transport.xmpp.XmppMessageConversation;
import org.mule.transport.xmpp.XmppMultiUserChatConversation;
import org.mule.transport.xmpp.i18n.XmppMessages;

public class XmppConversationFactory {
    public XmppConversation create(ImmutableEndpoint endpoint) {
        String type = endpoint.getEndpointURI().getHost();
        if ("MESSAGE".equals(type)) {
            return this.createMessageConversation(endpoint);
        }
        if ("CHAT".equals(type)) {
            return this.createChatConversation(endpoint);
        }
        if ("GROUPCHAT".equals(type)) {
            return this.createGroupchatConversation(endpoint);
        }
        throw new MuleRuntimeException(XmppMessages.invalidConversationType(type));
    }

    protected XmppConversation createMessageConversation(ImmutableEndpoint endpoint) {
        return new XmppMessageConversation(endpoint);
    }

    protected XmppConversation createChatConversation(ImmutableEndpoint endpoint) {
        return new XmppChatConversation(endpoint);
    }

    protected XmppConversation createGroupchatConversation(ImmutableEndpoint endpoint) {
        return new XmppMultiUserChatConversation(endpoint);
    }
}

