/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.mule.api.MuleException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.transport.MessageAdapterSerialization;
import org.mule.util.StringUtils;

public class XmppMessageAdapter
extends AbstractMessageAdapter
implements MessageAdapterSerialization {
    public static final String DEFAULT_SUBJECT = "(no subject)";
    public static final String DEFAULT_THREAD = "(no thread)";
    private static final long serialVersionUID = -4003299444661664762L;
    private final Packet packet;

    public XmppMessageAdapter(Object payload) throws MuleException {
        if (payload instanceof Packet) {
            this.packet = (Packet)payload;
            for (String name : this.packet.getPropertyNames()) {
                this.setProperty(name, this.packet.getProperty(name));
            }
            if (this.packet instanceof Message) {
                Message msg = (Message)this.packet;
                this.setProperty("subject", StringUtils.defaultIfEmpty((String)msg.getSubject(), (String)DEFAULT_SUBJECT));
                this.setProperty("thread", StringUtils.defaultIfEmpty((String)msg.getThread(), (String)DEFAULT_THREAD));
            }
        } else {
            throw new MessageTypeNotSupportedException(payload, ((Object)((Object)this)).getClass());
        }
    }

    protected XmppMessageAdapter(XmppMessageAdapter template) {
        super((MessageAdapter)template);
        this.packet = template.packet;
    }

    public String getPayloadAsString(String encoding) throws Exception {
        if (this.packet instanceof Message) {
            return ((Message)this.packet).getBody();
        }
        return this.packet.toString();
    }

    public byte[] getPayloadAsBytes() throws Exception {
        if (this.packet instanceof Message) {
            return ((Message)this.packet).getBody().getBytes();
        }
        return this.packet.toString().getBytes();
    }

    public Object getPayload() {
        return this.packet;
    }

    public String getUniqueId() {
        return this.packet.getPacketID();
    }

    public ThreadSafeAccess newThreadCopy() {
        return new XmppMessageAdapter(this);
    }

    public byte[] getPayloadForSerialization() throws Exception {
        return this.getPayloadAsBytes();
    }
}

