/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.jivesoftware.smack.packet.Message;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.xmpp.XmppConnector;
import org.mule.transport.xmpp.XmppConversation;

public class XmppPollingMessageReceiver
extends AbstractPollingMessageReceiver {
    private final XmppConnector connector;
    private XmppConversation conversation;

    public XmppPollingMessageReceiver(Connector conn, Service service, InboundEndpoint endpoint) throws CreateException {
        super(conn, service, endpoint);
        this.connector = (XmppConnector)conn;
        this.conversation = this.connector.getConversationFactory().create((ImmutableEndpoint)endpoint);
    }

    protected void doConnect() throws Exception {
        this.conversation.connect();
    }

    protected void doDisconnect() throws Exception {
        this.conversation.disconnect();
    }

    protected void doDispose() {
        this.conversation = null;
    }

    public void poll() throws Exception {
        long tenPercent;
        long frequency = this.getFrequency();
        long pollTimeout = frequency - (tenPercent = (long)((double)frequency * 0.1));
        Message xmppMessage = this.conversation.receive(pollTimeout);
        if (xmppMessage == null) {
            return;
        }
        this.processMessage(xmppMessage);
    }

    protected void processMessage(Message xmppMessage) throws MuleException {
        MessageAdapter messageAdapter = this.connector.getMessageAdapter(xmppMessage);
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)messageAdapter, this.connector.getMuleContext());
        this.routeMessage((MuleMessage)muleMessage, this.endpoint.isSynchronous());
    }
}

