/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp.config;

import org.mule.config.spring.factories.InboundEndpointFactoryBean;
import org.mule.config.spring.factories.OutboundEndpointFactoryBean;
import org.mule.config.spring.handlers.AbstractMuleNamespaceHandler;
import org.mule.config.spring.parsers.specific.TransformerDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.TransportEndpointDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.TransportGlobalEndpointDefinitionParser;
import org.mule.transport.xmpp.XmppConnector;
import org.mule.transport.xmpp.transformers.ObjectToXmppPacket;
import org.mule.transport.xmpp.transformers.XmppPacketToObject;

public class XmppNamespaceHandler
extends AbstractMuleNamespaceHandler {
    public static final String RECIPIENT = "recipient";
    public static final String[] REQUIRED_ADDRESS_ATTRIBUTES = new String[]{"recipient", "user", "host"};
    private static final String[][] REQUIRED_OUTBOUND_ATTRIBUTE_GROUPS = new String[][]{{"type", "recipient"}};
    private static final String[][] REQUIRED_INBOUND_ATTRIBUTE_GROUPS = new String[][]{{"type", "from"}};
    private static final String[][] REQUIRED_ALL_ATTRIBUTE_GROUPS = new String[][]{{"type", "from"}, {"type", "recipient"}};
    private static final String[][] REQUIRED_MESSAGE_PROPERTY_GROUPS = new String[][]{new String[0]};

    public void init() {
        this.registerGlobalEndpointParser();
        this.registerInboundEndpointParser();
        this.registerOutboundEndpintParser();
        this.registerConnectorDefinitionParser(XmppConnector.class);
        this.registerBeanDefinitionParser("xmpp-to-object-transformer", new TransformerDefinitionParser(XmppPacketToObject.class));
        this.registerBeanDefinitionParser("object-to-xmpp-transformer", new TransformerDefinitionParser(ObjectToXmppPacket.class));
    }

    private void registerGlobalEndpointParser() {
        TransportGlobalEndpointDefinitionParser endpointDefinitionParser = new TransportGlobalEndpointDefinitionParser("xmpp", false, TransportGlobalEndpointDefinitionParser.RESTRICTED_ENDPOINT_ATTRIBUTES, REQUIRED_ALL_ATTRIBUTE_GROUPS, REQUIRED_MESSAGE_PROPERTY_GROUPS);
        endpointDefinitionParser.addAlias("type", "host");
        endpointDefinitionParser.addAlias(RECIPIENT, "path");
        endpointDefinitionParser.addAlias("from", "path");
        this.registerBeanDefinitionParser("endpoint", endpointDefinitionParser);
    }

    private void registerInboundEndpointParser() {
        TransportEndpointDefinitionParser endpointDefinitionParser = new TransportEndpointDefinitionParser("xmpp", false, InboundEndpointFactoryBean.class, TransportEndpointDefinitionParser.RESTRICTED_ENDPOINT_ATTRIBUTES, REQUIRED_INBOUND_ATTRIBUTE_GROUPS, REQUIRED_MESSAGE_PROPERTY_GROUPS);
        endpointDefinitionParser.addAlias("type", "host");
        endpointDefinitionParser.addAlias("from", "path");
        this.registerBeanDefinitionParser("inbound-endpoint", endpointDefinitionParser);
    }

    private void registerOutboundEndpintParser() {
        TransportEndpointDefinitionParser endpointDefinitionParser = new TransportEndpointDefinitionParser("xmpp", false, OutboundEndpointFactoryBean.class, TransportEndpointDefinitionParser.RESTRICTED_ENDPOINT_ATTRIBUTES, REQUIRED_OUTBOUND_ATTRIBUTE_GROUPS, REQUIRED_MESSAGE_PROPERTY_GROUPS);
        endpointDefinitionParser.addAlias("type", "host");
        endpointDefinitionParser.addAlias(RECIPIENT, "path");
        this.registerBeanDefinitionParser("outbound-endpoint", endpointDefinitionParser);
    }
}

