/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.config;

import java.util.HashMap;
import org.mule.config.spring.parsers.collection.OrphanMapDefinitionParser;
import org.mule.util.ClassUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MixinMapDefinitionParser
extends OrphanMapDefinitionParser {
    public MixinMapDefinitionParser(Class mapClass) {
        super(mapClass);
    }

    public MixinMapDefinitionParser(Class mapClass, String name) {
        super(mapClass, name);
    }

    public MixinMapDefinitionParser(Class mapClass, String name, boolean attribute) {
        super(mapClass, name, attribute);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        HashMap<Class, Class> mixins = new HashMap<Class, Class>();
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Node node = element.getChildNodes().item(i);
            if (node.getNodeType() != 1) continue;
            String mixinClass = node.getAttributes().getNamedItem("mixinClass").getTextContent();
            String targetClass = node.getAttributes().getNamedItem("targetClass").getTextContent();
            try {
                mixins.put(ClassUtils.loadClass(targetClass, ((Object)((Object)this)).getClass()), ClassUtils.loadClass(mixinClass, ((Object)((Object)this)).getClass()));
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new BeanCreationException("Failed to create Mixin map", (Throwable)e);
            }
        }
        builder.addPropertyValue("sourceMap", mixins);
        builder.addPropertyValue("targetMapClass", (Object)this.mapClass.getName());
        this.getBeanAssembler(element, builder).setBeanFlag("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE");
    }
}

