/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import cryptix.jce.provider.CryptixCrypto;
import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.message.SignedMessage;
import cryptix.openpgp.provider.CryptixOpenPGP;
import cryptix.pki.KeyBundle;
import java.security.Provider;
import java.security.Security;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityException;
import org.mule.api.security.UnauthorisedException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.pgp.PGPAuthentication;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.module.pgp.PGPSecurityContextFactory;
import org.mule.module.pgp.i18n.PGPMessages;
import org.mule.security.AbstractSecurityProvider;

public class PGPSecurityProvider
extends AbstractSecurityProvider {
    private PGPKeyRing keyManager;

    public PGPSecurityProvider() {
        super("pgp");
    }

    public Authentication authenticate(Authentication authentication) throws SecurityException {
        PGPAuthentication auth = (PGPAuthentication)authentication;
        String userId = (String)auth.getPrincipal();
        if (userId == null) {
            throw new UnauthorisedException(CoreMessages.objectIsNull("UserId"));
        }
        KeyBundle userKeyBundle = this.keyManager.getKeyBundle(userId);
        if (userKeyBundle == null) {
            throw new UnauthorisedException(PGPMessages.noPublicKeyForUser(userId));
        }
        Message msg = (Message)auth.getCredentials();
        if (msg instanceof SignedMessage) {
            try {
                if (!((SignedMessage)msg).verify(userKeyBundle)) {
                    throw new UnauthorisedException(PGPMessages.invalidSignature());
                }
            }
            catch (MessageException e) {
                throw new UnauthorisedException(PGPMessages.errorVerifySignature(), (Throwable)e);
            }
        }
        auth.setAuthenticated(true);
        auth.setDetails(userKeyBundle);
        return auth;
    }

    public boolean supports(Class aClass) {
        return PGPAuthentication.class.isAssignableFrom(aClass);
    }

    protected void doInitialise() throws InitialisationException {
        try {
            Security.addProvider((Provider)new CryptixCrypto());
            Security.addProvider((Provider)new CryptixOpenPGP());
            this.setSecurityContextFactory(new PGPSecurityContextFactory());
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToCreate("PGPProvider"), (Throwable)e, this);
        }
    }

    public PGPKeyRing getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(PGPKeyRing keyManager) {
        this.keyManager = keyManager;
    }
}

