/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;

public class NumericComparer
implements AtomicComparer,
Serializable {
    private static NumericComparer THE_INSTANCE = new NumericComparer();

    public static NumericComparer getInstance() {
        return THE_INSTANCE;
    }

    private NumericComparer() {
    }

    public int compareAtomicValues(AtomicValue atomicValue, AtomicValue atomicValue2) {
        double d;
        double d2;
        if (atomicValue instanceof NumericValue) {
            d2 = ((NumericValue)atomicValue).getDoubleValue();
        } else if (atomicValue == null) {
            d2 = Double.NaN;
        } else {
            try {
                d2 = Value.stringToNumber(atomicValue.getStringValueCS());
            }
            catch (NumberFormatException numberFormatException) {
                d2 = Double.NaN;
            }
        }
        if (atomicValue2 instanceof NumericValue) {
            d = ((NumericValue)atomicValue2).getDoubleValue();
        } else if (atomicValue2 == null) {
            d = Double.NaN;
        } else {
            try {
                d = Value.stringToNumber(atomicValue2.getStringValueCS());
            }
            catch (NumberFormatException numberFormatException) {
                d = Double.NaN;
            }
        }
        if (Double.isNaN(d2)) {
            if (Double.isNaN(d)) {
                return 0;
            }
            return -1;
        }
        if (Double.isNaN(d)) {
            return 1;
        }
        if (d2 < d) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        return 0;
    }

    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        return this.compareAtomicValues(atomicValue, atomicValue2) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue atomicValue) {
        if (atomicValue instanceof NumericValue) {
            return new ComparisonKey(635, this.toDoubleValue((NumericValue)atomicValue));
        }
        if (atomicValue == null) {
            return new ComparisonKey(635, "NaN");
        }
        try {
            double d = Value.stringToNumber(atomicValue.getStringValueCS());
            return new ComparisonKey(635, new DoubleValue(d));
        }
        catch (NumberFormatException numberFormatException) {
            return new ComparisonKey(635, "NaN");
        }
    }

    private DoubleValue toDoubleValue(NumericValue numericValue) {
        if (numericValue instanceof DoubleValue) {
            return (DoubleValue)numericValue;
        }
        return new DoubleValue(numericValue.getDoubleValue());
    }
}

