/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.io.IOException;
import java.util.Map;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.PropertyScope;
import org.mule.module.json.JsonData;
import org.mule.module.json.filters.IsJsonFilter;
import org.mule.transport.AbstractMessageAdapter;

public class AjaxMessageAdapter
extends AbstractMessageAdapter {
    public static final String REPLYTO_PARAM = "replyTo";
    protected transient IsJsonFilter filter = new IsJsonFilter();
    protected Object payload;

    public AjaxMessageAdapter(Object message) throws MuleException {
        this.init(message);
    }

    public AjaxMessageAdapter(Object message, MessageAdapter template) throws MuleException {
        super(template);
        this.init(message);
    }

    protected void init(Object message) throws MuleException {
        if (message instanceof Map) {
            Map map = (Map)message;
            Object p = map.remove("data");
            if (p == null) {
                throw new IllegalArgumentException("data parameter not set");
            }
            this.payload = p;
            this.setReplyTo(map.remove(REPLYTO_PARAM));
            if (map.size() > 0) {
                this.addProperties(map, PropertyScope.INVOCATION);
            }
        } else if (this.filter.accept(message)) {
            if (message.toString().indexOf("data") > -1) {
                try {
                    JsonData jd = new JsonData(message.toString());
                    this.payload = jd.get("data").toString();
                    this.setReplyTo(jd.get(REPLYTO_PARAM));
                }
                catch (IOException e) {
                    throw new DefaultMuleException(e);
                }
            } else {
                this.payload = message;
            }
        } else {
            this.payload = message;
        }
    }

    public Object getPayload() {
        return this.payload;
    }
}

