/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.rmi;

import java.lang.reflect.Method;
import java.net.InetAddress;
import javax.naming.Context;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.rmi.RmiAble;
import org.mule.transport.rmi.RmiConnector;
import org.mule.transport.rmi.i18n.RmiMessages;
import org.mule.util.ClassUtils;

public class RmiCallbackMessageReceiver
extends AbstractMessageReceiver {
    public static final String PROPERTY_SERVICE_CLASS_NAME = "serviceClassName";
    protected RmiConnector connector;
    protected RmiAble remoteObject = null;
    private Context jndi = null;
    private String bindName = null;
    private int port;

    public RmiCallbackMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, service, endpoint);
        this.connector = (RmiConnector)connector;
        this.logger.debug((Object)("Initializing with endpoint " + endpoint));
        String rmiPolicyPath = this.connector.getSecurityPolicy();
        System.setProperty("java.security.policy", rmiPolicyPath);
        EndpointURI endpointUri = endpoint.getEndpointURI();
        this.port = endpointUri.getPort();
        if (this.port < 1) {
            this.port = 1099;
        }
        this.logger.debug((Object)"Initialized successfully");
    }

    protected void doDispose() {
    }

    protected void doConnect() throws ConnectException {
        block4: {
            try {
                if (null != this.remoteObject) break block4;
                try {
                    InetAddress inetAddress = InetAddress.getByName(this.endpoint.getEndpointURI().getHost());
                    this.bindName = this.endpoint.getEndpointURI().getPath();
                    this.remoteObject = this.getRmiObject();
                    Method theMethod = this.remoteObject.getClass().getMethod("setReceiver", RmiCallbackMessageReceiver.class);
                    theMethod.invoke((Object)this.remoteObject, new Object[]{this});
                    this.jndi = this.connector.getJndiContext(inetAddress.getHostAddress() + ":" + this.port);
                    this.jndi.rebind(this.bindName, (Object)this.remoteObject);
                }
                catch (Exception e) {
                    throw new ConnectException((Throwable)e, (Object)this);
                }
            }
            catch (Exception e) {
                throw new ConnectException((Throwable)e, (Object)this);
            }
        }
    }

    protected void doDisconnect() {
        this.logger.debug((Object)"Disconnecting...");
        try {
            this.jndi.unbind(this.bindName);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        this.logger.debug((Object)"Disconnected successfully.");
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    private RmiAble getRmiObject() throws ConnectException {
        RmiAble remote;
        String className = (String)this.endpoint.getProperty((Object)PROPERTY_SERVICE_CLASS_NAME);
        if (null == className) {
            throw new ConnectException(RmiMessages.messageReceiverNeedsRmiAble(), (Object)this);
        }
        try {
            remote = (RmiAble)ClassUtils.instanciateClass((String)className, (Object[])new Object[0], ((Object)((Object)this)).getClass());
        }
        catch (Exception e) {
            throw new ConnectException(RmiMessages.serviceClassInvocationFailed(), (Throwable)e, (Object)this);
        }
        return remote;
    }

    public Object routeMessage(Object message) throws MuleException {
        MessageAdapter adapter = this.connector.getMessageAdapter(message);
        return this.routeMessage((MuleMessage)new DefaultMuleMessage((Object)adapter, this.connector.getMuleContext()));
    }
}

