/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.rmi;

import java.lang.reflect.Method;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.util.Collections;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transformer.TransformerException;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.rmi.RmiConnector;

public class RmiMessageDispatcher
extends AbstractMessageDispatcher {
    private final RmiConnector connector;
    protected volatile Remote remoteObject;
    protected volatile Method invokedMethod;

    public RmiMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (RmiConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
        if (this.remoteObject == null) {
            String rmiPolicyPath = this.connector.getSecurityPolicy();
            System.setProperty("java.security.policy", rmiPolicyPath);
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            this.remoteObject = this.connector.getRemoteObject(this.endpoint);
        }
    }

    protected void doDisconnect() throws Exception {
        this.remoteObject = null;
        this.invokedMethod = null;
    }

    private Object[] getArgs(MuleEvent event) throws TransformerException {
        Object payload = event.transformMessage();
        if (payload instanceof Object[]) {
            return (Object[])payload;
        }
        return new Object[]{payload};
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        Object[] arguments = this.getArgs(event);
        if (this.invokedMethod == null) {
            this.invokedMethod = this.connector.getMethodObject(this.remoteObject, event);
        }
        this.invokedMethod.invoke((Object)this.remoteObject, arguments);
    }

    public MuleMessage doSend(MuleEvent event) throws Exception {
        Object[] arguments;
        Object result;
        if (this.invokedMethod == null) {
            this.invokedMethod = this.connector.getMethodObject(this.remoteObject, event);
        }
        if ((result = this.invokedMethod.invoke((Object)this.remoteObject, arguments = this.getArgs(event))) == null) {
            return new DefaultMuleMessage((Object)NullPayload.getInstance(), this.connector.getMuleContext());
        }
        return new DefaultMuleMessage(this.connector.getMessageAdapter(result).getPayload(), Collections.EMPTY_MAP, this.connector.getMuleContext());
    }

    protected void doDispose() {
    }
}

