/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.client.remoting;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.AbstractAgent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.transformer.wire.WireFormat;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.client.remoting.RemoteDispatcherComponent;
import org.mule.module.client.remoting.notification.RemoteDispatcherNotification;
import org.mule.module.client.remoting.notification.RemoteDispatcherNotificationListener;
import org.mule.transformer.wire.SerializedMuleMessageWireFormat;

public class RemoteDispatcherAgent
extends AbstractAgent {
    public static final String AGENT_NAME = "RemoteDispatcherServer";
    protected static final Log logger = LogFactory.getLog(RemoteDispatcherAgent.class);
    private WireFormat wireFormat;
    private InboundEndpoint endpoint;

    public RemoteDispatcherAgent() {
        super(AGENT_NAME);
    }

    public String getDescription() {
        return this.getName() + ": accepting connections on " + this.endpoint.getEndpointURI().getAddress();
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public void dispose() {
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void initialise() throws InitialisationException {
        if (this.endpoint == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("remote-endpoint").getMessage());
        }
        if (this.wireFormat == null) {
            this.wireFormat = new SerializedMuleMessageWireFormat();
        }
        this.wireFormat.setMuleContext(this.muleContext);
        this.muleContext.getNotificationManager().addInterfaceToType(RemoteDispatcherNotificationListener.class, RemoteDispatcherNotification.class);
        try {
            if (this.muleContext.getRegistry().lookupService("_muleManagerComponent") != null) {
                logger.info((Object)"Mule manager component has already been initialised, ignoring server url");
            } else {
                Service component = RemoteDispatcherComponent.getSerivce(this.endpoint, this.wireFormat, this.muleContext.getConfiguration().getDefaultEncoding(), this.muleContext.getConfiguration().getDefaultResponseTimeout(), this.muleContext);
                this.muleContext.getRegistry().registerService(component);
            }
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public String toString() {
        String address = "not set";
        if (this.endpoint != null) {
            address = this.endpoint.getEndpointURI().getAddress();
        }
        return "RemoteDispatcherAgent{remote-endpoint='" + address + "'" + "}";
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public InboundEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(InboundEndpoint endpoint) {
        this.endpoint = endpoint;
    }
}

