/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.expression;

import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.xml.i18n.XmlMessages;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.module.xml.util.XMLUtils;

public class JXPathExpressionEvaluator
implements ExpressionEvaluator {
    public static final String NAME = "jxpath";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private MuleContext muleContext;
    private NamespaceManager namespaceManager;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        try {
            this.namespaceManager = this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
        }
        catch (RegistrationException e) {
            throw new ExpressionRuntimeException(CoreMessages.failedToLoad("NamespaceManager"), (Throwable)e);
        }
    }

    public Object evaluate(String name, MuleMessage message) {
        Object result;
        block7: {
            Document doc;
            result = null;
            Object payload = message.getPayload();
            JXPathContext context = JXPathContext.newContext((Object)message.getPayload());
            if (this.namespaceManager != null) {
                this.addNamespaces(this.namespaceManager, context);
            }
            try {
                doc = XMLUtils.toDocument(payload, this.muleContext);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                return null;
            }
            if (doc != null) {
                result = doc.valueOf(name);
            } else {
                try {
                    result = context.getValue(name);
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block7;
                    this.logger.debug((Object)("failed to process JXPath expression: " + name), (Throwable)e);
                }
            }
        }
        return result;
    }

    protected void addNamespaces(NamespaceManager manager, JXPathContext context) {
        for (Map.Entry entry : manager.getNamespaces().entrySet()) {
            try {
                context.registerNamespace(entry.getKey().toString(), entry.getValue().toString());
            }
            catch (Exception e) {
                throw new ExpressionRuntimeException(XmlMessages.failedToRegisterNamespace(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }
}

