/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.module.xml.transformer.DelayedResult;
import org.mule.module.xml.util.XMLUtils;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class AbstractXmlTransformer
extends AbstractMessageAwareTransformer {
    private String outputEncoding;
    private XMLInputFactory xmlInputFactory;
    private XMLOutputFactory xmlOutputFactory;
    private boolean useStaxSource = false;

    public AbstractXmlTransformer() {
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(Source.class);
        this.registerSourceType(InputSource.class);
        this.registerSourceType(Document.class);
        this.registerSourceType(org.w3c.dom.Document.class);
        this.registerSourceType(Element.class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(OutputHandler.class);
        this.registerSourceType(XMLStreamReader.class);
        this.registerSourceType(DelayedResult.class);
        this.setReturnClass((Class)byte[].class);
        this.xmlInputFactory = XMLInputFactory.newInstance();
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
    }

    protected static ResultHolder getResultHolder(Class desiredClass) {
        if (desiredClass == null) {
            return null;
        }
        if (byte[].class.equals((Object)desiredClass) || InputStream.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
                StreamResult result = new StreamResult((OutputStream)this.resultStream);

                public Result getResult() {
                    return this.result;
                }

                public Object getResultObject() {
                    return this.resultStream.toByteArray();
                }
            };
        }
        if (String.class.equals((Object)desiredClass)) {
            return new ResultHolder(){
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(this.writer);

                public Result getResult() {
                    return this.result;
                }

                public Object getResultObject() {
                    return this.writer.getBuffer().toString();
                }
            };
        }
        if (org.w3c.dom.Document.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                DOMResult result = new DOMResult();

                public Result getResult() {
                    return this.result;
                }

                public Object getResultObject() {
                    return this.result.getNode();
                }
            };
        }
        if (DocumentResult.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                DocumentResult result = new DocumentResult();

                public Result getResult() {
                    return this.result;
                }

                public Object getResultObject() {
                    return this.result;
                }
            };
        }
        if (Document.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                DocumentResult result = new DocumentResult();

                public Result getResult() {
                    return this.result;
                }

                public Object getResultObject() {
                    return this.result.getDocument();
                }
            };
        }
        return null;
    }

    protected String convertToText(Object obj) throws TransformerFactoryConfigurationError, javax.xml.transform.TransformerException, TransformerException {
        return this.convertToText(obj, null);
    }

    protected String convertToText(Object obj, String outputEncoding) throws TransformerFactoryConfigurationError, javax.xml.transform.TransformerException, TransformerException {
        Source src;
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Document) {
            return ((Document)obj).asXML();
        }
        try {
            src = XMLUtils.toXmlSource(this.xmlInputFactory, this.useStaxSource, obj);
            if (src == null) {
                return null;
            }
        }
        catch (Exception e) {
            if (e instanceof TransformerException) {
                throw (TransformerException)e;
            }
            throw new TransformerException(this, (Throwable)e);
        }
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
        if (outputEncoding != null) {
            idTransformer.setOutputProperty("encoding", outputEncoding);
        }
        idTransformer.transform(src, result);
        return writer.getBuffer().toString();
    }

    protected String convertToBytes(Object obj, String outputEncoding) throws TransformerFactoryConfigurationError, javax.xml.transform.TransformerException, TransformerException {
        Source src;
        try {
            src = XMLUtils.toXmlSource(this.xmlInputFactory, this.useStaxSource, obj);
            if (src == null) {
                return null;
            }
        }
        catch (Exception e) {
            if (e instanceof TransformerException) {
                throw (TransformerException)e;
            }
            throw new TransformerException(this, (Throwable)e);
        }
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer idTransformer = XMLUtils.getTransformer();
        idTransformer.setOutputProperty("encoding", outputEncoding);
        idTransformer.transform(src, result);
        return writer.getBuffer().toString();
    }

    protected void writeToStream(Object obj, String outputEncoding, OutputStream output) throws TransformerFactoryConfigurationError, javax.xml.transform.TransformerException, TransformerException {
        Source src;
        try {
            src = XMLUtils.toXmlSource(this.xmlInputFactory, this.useStaxSource, obj);
            if (src == null) {
                return;
            }
        }
        catch (Exception e) {
            if (e instanceof TransformerException) {
                throw (TransformerException)e;
            }
            throw new TransformerException(this, (Throwable)e);
        }
        StreamResult result = new StreamResult(output);
        Transformer idTransformer = XMLUtils.getTransformer();
        idTransformer.setOutputProperty("encoding", outputEncoding);
        idTransformer.transform(src, result);
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public boolean isUseStaxSource() {
        return this.useStaxSource;
    }

    public void setUseStaxSource(boolean useStaxSource) {
        this.useStaxSource = useStaxSource;
    }

    public XMLInputFactory getXMLInputFactory() {
        return this.xmlInputFactory;
    }

    public void setXMLInputFactory(XMLInputFactory xmlInputFactory) {
        this.xmlInputFactory = xmlInputFactory;
    }

    public XMLOutputFactory getXMLOutputFactory() {
        return this.xmlOutputFactory;
    }

    public void setXMLOutputFactory(XMLOutputFactory xmlOutputFactory) {
        this.xmlOutputFactory = xmlOutputFactory;
    }

    protected static interface ResultHolder {
        public Result getResult();

        public Object getResultObject();
    }
}

