/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.transport.OutputHandler;
import org.mule.module.xml.stax.DelegateXMLStreamReader;
import org.mule.module.xml.stax.StaxSource;
import org.mule.module.xml.transformer.DelayedResult;
import org.mule.module.xml.transformer.XmlToDomDocument;
import org.mule.util.IOUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLUtils
extends org.mule.util.XMLUtils {
    public static final String TRANSFORMER_FACTORY_JDK5 = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    public static final String APACHE_XML_FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    public static final String APACHE_XML_FEATURES_VALIDATION_SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String JAXP_PROPERTIES_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String JAXP_PROPERTIES_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_PROPERTIES_SCHEMA_LANGUAGE_VALUE = "http://www.w3.org/2001/XMLSchema";

    public static String toXml(org.w3c.dom.Document dom) {
        return new DOMReader().read(dom).asXML();
    }

    public static Transformer getTransformer() throws TransformerConfigurationException {
        TransformerFactory tf;
        try {
            tf = TransformerFactory.newInstance();
        }
        catch (TransformerFactoryConfigurationError e) {
            System.setProperty("javax.xml.transform.TransformerFactory", TRANSFORMER_FACTORY_JDK5);
            tf = TransformerFactory.newInstance();
        }
        if (tf != null) {
            return tf.newTransformer();
        }
        throw new TransformerConfigurationException("Unable to instantiate a TransformerFactory");
    }

    public static Document toDocument(Object obj, MuleContext muleContext) throws Exception {
        return XMLUtils.toDocument(obj, null, muleContext);
    }

    public static Document toDocument(Object obj, String externalSchemaLocation, MuleContext muleContext) throws Exception {
        SAXReader reader = new SAXReader();
        if (externalSchemaLocation != null) {
            reader.setValidation(true);
            reader.setFeature(APACHE_XML_FEATURES_VALIDATION_SCHEMA, true);
            reader.setFeature(APACHE_XML_FEATURES_VALIDATION_SCHEMA_FULL_CHECKING, true);
            InputStream xsdAsStream = IOUtils.getResourceAsStream(externalSchemaLocation, XMLUtils.class);
            if (xsdAsStream == null) {
                throw new IllegalArgumentException("Couldn't find schema at " + externalSchemaLocation);
            }
            reader.setProperty(JAXP_PROPERTIES_SCHEMA_LANGUAGE, (Object)JAXP_PROPERTIES_SCHEMA_LANGUAGE_VALUE);
            reader.setProperty(JAXP_PROPERTIES_SCHEMA_SOURCE, (Object)xsdAsStream);
        }
        if (obj instanceof Document) {
            return (Document)obj;
        }
        if (obj instanceof org.w3c.dom.Document) {
            DOMReader domReader = new DOMReader();
            return domReader.read((org.w3c.dom.Document)obj);
        }
        if (obj instanceof InputSource) {
            return reader.read((InputSource)obj);
        }
        if (obj instanceof Source || obj instanceof XMLStreamReader) {
            XmlToDomDocument tr = new XmlToDomDocument();
            tr.setMuleContext(muleContext);
            tr.setReturnClass((Class)Document.class);
            return (Document)tr.transform(obj);
        }
        if (obj instanceof InputStream) {
            return reader.read((InputStream)obj);
        }
        if (obj instanceof String) {
            return reader.read((Reader)new StringReader((String)obj));
        }
        if (obj instanceof byte[]) {
            return reader.read((Reader)new StringReader(new String((byte[])obj)));
        }
        if (obj instanceof File) {
            return reader.read((File)obj);
        }
        return null;
    }

    public static XMLStreamReader toXMLStreamReader(XMLInputFactory factory, Object obj) throws XMLStreamException {
        if (obj instanceof XMLStreamReader) {
            return (XMLStreamReader)obj;
        }
        if (obj instanceof StaxSource) {
            return ((StaxSource)((Object)obj)).getXMLStreamReader();
        }
        if (obj instanceof Source) {
            return factory.createXMLStreamReader((Source)obj);
        }
        if (obj instanceof InputSource) {
            return factory.createXMLStreamReader(((InputSource)obj).getByteStream());
        }
        if (obj instanceof org.w3c.dom.Document) {
            return factory.createXMLStreamReader(new DOMSource((org.w3c.dom.Document)obj));
        }
        if (obj instanceof Document) {
            return factory.createXMLStreamReader((Source)new DocumentSource((Document)obj));
        }
        if (obj instanceof InputStream) {
            final InputStream is = (InputStream)obj;
            XMLStreamReader xsr = factory.createXMLStreamReader(is);
            return new DelegateXMLStreamReader(xsr){

                public void close() throws XMLStreamException {
                    super.close();
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new XMLStreamException(e);
                    }
                }
            };
        }
        if (obj instanceof String) {
            return factory.createXMLStreamReader(new StringReader((String)obj));
        }
        if (obj instanceof byte[]) {
            return factory.createXMLStreamReader(new ByteArrayInputStream((byte[])obj));
        }
        return null;
    }

    public static Source toXmlSource(XMLInputFactory xmlInputFactory, boolean useStaxSource, Object src) throws Exception {
        if (src instanceof Source) {
            return (Source)src;
        }
        if (src instanceof byte[]) {
            ByteArrayInputStream stream = new ByteArrayInputStream((byte[])src);
            return XMLUtils.toStreamSource(xmlInputFactory, useStaxSource, stream);
        }
        if (src instanceof InputStream) {
            return XMLUtils.toStreamSource(xmlInputFactory, useStaxSource, (InputStream)src);
        }
        if (src instanceof String) {
            if (useStaxSource) {
                return new StaxSource(xmlInputFactory.createXMLStreamReader(new StringReader((String)src)));
            }
            return new StreamSource(new StringReader((String)src));
        }
        if (src instanceof Document) {
            return new DocumentSource((Document)src);
        }
        if (src instanceof InputSource) {
            return new SAXSource((InputSource)src);
        }
        if (src instanceof XMLStreamReader) {
            XMLStreamReader xsr = (XMLStreamReader)src;
            if (!xsr.isStartElement() && xsr.getEventType() != 7) {
                xsr.nextTag();
            }
            return new StaxSource((XMLStreamReader)src);
        }
        if (src instanceof org.w3c.dom.Document || src instanceof Element) {
            return new DOMSource((Node)src);
        }
        if (src instanceof DelayedResult) {
            DelayedResult result = (DelayedResult)src;
            DOMResult domResult = new DOMResult();
            result.write(domResult);
            return new DOMSource(domResult.getNode());
        }
        if (src instanceof OutputHandler) {
            OutputHandler handler = (OutputHandler)src;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            handler.write(RequestContext.getEvent(), (OutputStream)output);
            return XMLUtils.toStreamSource(xmlInputFactory, useStaxSource, new ByteArrayInputStream(output.toByteArray()));
        }
        return null;
    }

    public static Source toStreamSource(XMLInputFactory xmlInputFactory, boolean useStaxSource, InputStream stream) throws XMLStreamException {
        if (useStaxSource) {
            return new StaxSource(xmlInputFactory.createXMLStreamReader(stream));
        }
        return new StreamSource(stream);
    }

    public static void copy(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        XMLUtils.copy(reader, writer, false);
    }

    public static void copy(XMLStreamReader reader, XMLStreamWriter writer, boolean fragment) throws XMLStreamException {
        int read = 0;
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    ++read;
                    XMLUtils.writeStartElement(reader, writer);
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (--read > 0 || fragment) break;
                    return;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 13: {
                    break;
                }
            }
            event = reader.next();
        }
    }

    private static void writeStartElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String nsPrefix;
        int i;
        String boundPrefix;
        String local = reader.getLocalName();
        String uri = reader.getNamespaceURI();
        String prefix = reader.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        boolean writeElementNS = false;
        if (!(uri == null || (boundPrefix = writer.getPrefix(uri)) != null && prefix.equals(boundPrefix))) {
            writeElementNS = true;
        }
        if (uri != null) {
            if (prefix.length() == 0 && StringUtils.isEmpty((String)uri)) {
                writer.writeStartElement(local);
                writer.setDefaultNamespace(uri);
            } else {
                writer.writeStartElement(prefix, local, uri);
                writer.setPrefix(prefix, uri);
            }
        } else {
            writer.writeStartElement(local);
        }
        for (i = 0; i < reader.getNamespaceCount(); ++i) {
            String nsURI = reader.getNamespaceURI(i);
            nsPrefix = reader.getNamespacePrefix(i);
            if (nsPrefix == null) {
                nsPrefix = "";
            }
            if (nsPrefix.length() == 0) {
                writer.writeDefaultNamespace(nsURI);
            } else {
                writer.writeNamespace(nsPrefix, nsURI);
            }
            if (!nsURI.equals(uri) || !nsPrefix.equals(prefix)) continue;
            writeElementNS = false;
        }
        if (writeElementNS) {
            if (prefix == null || prefix.length() == 0) {
                writer.writeDefaultNamespace(uri);
            } else {
                writer.writeNamespace(prefix, uri);
            }
        }
        for (i = 0; i < reader.getAttributeCount(); ++i) {
            String ns = reader.getAttributeNamespace(i);
            nsPrefix = reader.getAttributePrefix(i);
            if (ns == null || ns.length() == 0) {
                writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            if (nsPrefix == null || nsPrefix.length() == 0) {
                writer.writeAttribute(reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }
}

