/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jbpm;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.internal.log.Log;
import org.jbpm.jpdl.internal.activity.JpdlActivity;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.script.ScriptManager;
import org.mule.api.MuleMessage;
import org.mule.transport.bpm.MessageService;
import org.mule.transport.jbpm.MuleMessageService;
import org.mule.util.ClassUtils;

public class MuleSendActivity
extends JpdlActivity
implements EventListener {
    private boolean synchronous;
    private String endpoint;
    private Class responsePayloadClass;
    private String responseVariableName;
    private String payloadExpression;
    private Object payloadObject;
    private static final Log log = Log.getLog((String)MuleSendActivity.class.getName());

    public void execute(ActivityExecution execution) throws Exception {
        this.perform((OpenExecution)execution);
        ((ExecutionImpl)execution).historyAutomatic();
    }

    public void notify(EventListenerExecution execution) throws Exception {
        this.perform((OpenExecution)execution);
    }

    public void perform(OpenExecution execution) throws Exception {
        MessageService mule = (MessageService)EnvironmentImpl.getCurrent().get(MuleMessageService.class);
        if (mule == null) {
            throw new JbpmException("The Mule MessageService is not available from the ProcessEngine, you may need to add it to your jbpm.cfg.xml file");
        }
        if (this.payloadExpression == null) {
            this.payloadObject = execution.getVariable("data");
            if (this.payloadObject == null) {
                this.payloadObject = execution.getVariable("incoming");
            }
        } else {
            this.payloadObject = ScriptManager.getScriptManager().evaluateExpression(this.payloadExpression, null);
        }
        if (this.payloadObject == null) {
            throw new IllegalArgumentException("Payload for message is null.  Payload source is \"" + this.payloadExpression + "\"");
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("MULE_BPM_PROCESS_TYPE", ((ExecutionImpl)execution).getProcessDefinition().getName());
        props.put("MULE_BPM_PROCESS_ID", execution.getId());
        for (Map.Entry var : execution.getVariables().entrySet()) {
            if (((String)var.getKey()).startsWith("MULE_")) continue;
            props.put((String)var.getKey(), (String)var.getValue());
        }
        MuleMessage response = mule.generateMessage(this.endpoint, this.payloadObject, props, this.synchronous);
        if (this.synchronous && response != null) {
            Object responsePayload = response.getPayload();
            if (this.responsePayloadClass != null) {
                log.debug("Validating response type = " + responsePayload.getClass() + ", expected = " + this.responsePayloadClass);
                if (!this.responsePayloadClass.isAssignableFrom(responsePayload.getClass())) {
                    throw new JbpmException("Response message is of type " + responsePayload.getClass() + " but expected type is " + this.responsePayloadClass);
                }
            }
            if (this.responseVariableName != null) {
                if (responsePayload != null) {
                    execution.setVariable(this.responseVariableName, responsePayload);
                } else {
                    log.info("Synchronous message was sent to endpoint " + this.endpoint + ", but no response was returned.");
                }
            }
        }
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getPayloadExpression() {
        return this.payloadExpression;
    }

    public void setPayloadExpression(String payloadExpression) {
        this.payloadExpression = payloadExpression;
    }

    public String getResponseVariableName() {
        return this.responseVariableName;
    }

    public void setResponseVariableName(String responseVariableName) {
        this.responseVariableName = responseVariableName;
    }

    public void setResponsePayloadClass(String className) {
        if (className != null) {
            try {
                this.responsePayloadClass = ClassUtils.loadClass((String)className, ((Object)((Object)this)).getClass());
            }
            catch (ClassNotFoundException e) {
                log.error("Expected message type not valid: " + e.getMessage());
            }
        }
    }

    public Class getResponsePayloadClass() {
        return this.responsePayloadClass;
    }
}

