/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jaas;

import java.io.IOException;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityException;
import org.mule.api.security.UnauthorisedException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jaas.JaasAuthentication;
import org.mule.module.jaas.MuleCallbackHandler;
import org.mule.security.AbstractSecurityProvider;
import org.mule.util.FileUtils;

public class JaasSimpleAuthenticationProvider
extends AbstractSecurityProvider {
    private String loginConfig;
    private String loginContextName;
    private String credentials;
    private String loginModule;
    private String defaultModule = "org.mule.module.jaas.loginmodule.DefaultLoginModule";

    public JaasSimpleAuthenticationProvider() {
        super("jaas");
    }

    public final void setLoginConfig(String loginConfig) {
        this.loginConfig = loginConfig;
    }

    public final String getLoginConfig() {
        return this.loginConfig;
    }

    public final void setLoginContextName(String loginContextName) {
        this.loginContextName = loginContextName;
    }

    public final String getLoginContextName() {
        return this.loginContextName;
    }

    public final String getCredentials() {
        return this.credentials;
    }

    public final void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public final String getLoginModule() {
        return this.loginModule;
    }

    public final void setLoginModule(String loginModule) {
        this.loginModule = loginModule;
    }

    private void configureJaas() throws IOException {
        String loginConfigUrl = "file://" + FileUtils.getResourcePath(this.loginConfig, JaasSimpleAuthenticationProvider.class);
        boolean alreadySet = false;
        int n = 1;
        String prefix = "login.config.url.";
        String existing = null;
        while ((existing = Security.getProperty(prefix + n)) != null && !(alreadySet = existing.equals(loginConfigUrl))) {
            ++n;
        }
        if (!alreadySet) {
            String key = prefix + n;
            Security.setProperty(key, loginConfigUrl);
        }
    }

    public final Authentication authenticate(Authentication authentication) throws SecurityException {
        LoginContext loginContext;
        JaasAuthentication auth = (JaasAuthentication)authentication;
        MuleCallbackHandler cbh = new MuleCallbackHandler(auth);
        try {
            loginContext = auth.getSubject() != null ? new LoginContext(this.loginContextName, auth.getSubject(), cbh) : new LoginContext(this.loginContextName, cbh);
        }
        catch (LoginException e) {
            throw new UnauthorisedException(CoreMessages.cannotLoadFromClasspath(this.loginContextName));
        }
        try {
            loginContext.login();
        }
        catch (LoginException le) {
            le.fillInStackTrace();
            throw new UnauthorisedException(CoreMessages.authFailedForUser(auth.getPrincipal()));
        }
        Subject subject = loginContext.getSubject();
        JaasAuthentication finalAuth = new JaasAuthentication(auth.getPrincipal(), auth.getCredentials(), subject);
        finalAuth.setAuthenticated(true);
        return finalAuth;
    }

    protected void doInitialise() throws InitialisationException {
        if (this.loginConfig == null) {
            try {
                AppConfigurationEntry entry = null;
                JaasConfig.init();
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("credentials", this.credentials);
                entry = this.loginModule != null ? new AppConfigurationEntry(this.loginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options) : new AppConfigurationEntry(this.defaultModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                JaasConfig.addApplicationConfigEntry(this.loginContextName, entry);
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        try {
            this.configureJaas();
        }
        catch (IOException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public static class JaasConfig
    extends Configuration {
        private static Map appConfigEntries = new HashMap();
        private static JaasConfig jaasConfig;

        public static void init() {
            jaasConfig = new JaasConfig();
            Configuration.setConfiguration(jaasConfig);
        }

        public static JaasConfig getJaasConfig() {
            return jaasConfig;
        }

        public static void addApplicationConfigEntry(String name, AppConfigurationEntry entry) {
            appConfigEntries.put(name, entry);
        }

        public final AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
            if (applicationName == null) {
                throw new IllegalArgumentException("applicationName passed in was null.");
            }
            AppConfigurationEntry entry = (AppConfigurationEntry)appConfigEntries.get(applicationName);
            if (entry == null) {
                return new AppConfigurationEntry[0];
            }
            AppConfigurationEntry[] e = new AppConfigurationEntry[]{entry};
            return e;
        }

        public void refresh() {
        }
    }
}

