/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jaas.filters;

import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.Authentication;
import org.mule.api.security.CredentialsNotSetException;
import org.mule.api.security.CryptoFailureException;
import org.mule.api.security.EncryptionStrategyNotFoundException;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnauthorisedException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jaas.JaasAuthentication;
import org.mule.security.AbstractEndpointSecurityFilter;
import org.mule.security.MuleCredentials;
import org.mule.security.MuleHeaderCredentialsAccessor;

public class JaasSecurityFilter
extends AbstractEndpointSecurityFilter {
    public JaasSecurityFilter() {
        this.setCredentialsAccessor(new MuleHeaderCredentialsAccessor());
    }

    protected final void authenticateInbound(MuleEvent event) throws SecurityException, CryptoFailureException, EncryptionStrategyNotFoundException, UnknownAuthenticationTypeException {
        Authentication authResult;
        String userHeader = (String)this.getCredentialsAccessor().getCredentials(event);
        if (userHeader == null) {
            throw new CredentialsNotSetException(event.getMessage(), event.getSession().getSecurityContext(), event.getEndpoint(), this);
        }
        MuleCredentials user = new MuleCredentials(userHeader, this.getSecurityManager());
        JaasAuthentication authentication = new JaasAuthentication(user);
        try {
            authResult = this.getSecurityManager().authenticate(authentication);
        }
        catch (SecurityException se) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Security Exception raised. Authentication request for user: " + user.getUsername() + " failed: " + se.toString()));
            }
            throw se;
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Authentication request for user: " + user.getUsername() + " failed: " + e.toString()));
            }
            throw new UnauthorisedException(CoreMessages.authFailedForUser(user.getUsername()), event.getMessage(), e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication success: " + authResult.toString()));
        }
        SecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
        context.setAuthentication(authResult);
        event.getSession().setSecurityContext(context);
    }

    protected void authenticateOutbound(MuleEvent event) throws SecurityException, SecurityProviderNotFoundException, CryptoFailureException {
        if (event.getSession().getSecurityContext() == null) {
            if (this.isAuthenticate()) {
                throw new UnauthorisedException(event.getMessage(), event.getSession().getSecurityContext(), event.getEndpoint(), this);
            }
            return;
        }
        Authentication auth = event.getSession().getSecurityContext().getAuthentication();
        if (this.isAuthenticate()) {
            auth = this.getSecurityManager().authenticate(auth);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Authentication success: " + auth.toString()));
            }
        }
        String token = auth.getCredentials().toString();
        this.getCredentialsAccessor().setCredentials(event, token);
    }

    protected void doInitialise() throws InitialisationException {
    }
}

