/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.lang.BooleanUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.OutputHandler;
import org.mule.api.transport.PropertyScope;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.message.DefaultExceptionPayload;
import org.mule.transformer.TransformerChain;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.http.CookieHelper;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpMessageAdapter;
import org.mule.transport.http.HttpResponseException;
import org.mule.transport.http.MuleHttpMethodRetryHandler;
import org.mule.transport.http.ReleasingInputStream;
import org.mule.transport.http.StreamPayloadRequestEntity;
import org.mule.transport.http.transformers.ObjectToHttpClientMethodRequest;
import org.mule.util.StringUtils;

public class HttpClientMessageDispatcher
extends AbstractMessageDispatcher {
    public static final int ERROR_STATUS_CODE_RANGE_START = 400;
    public static final int REDIRECT_STATUS_CODE_RANGE_START = 300;
    protected final HttpConnector connector;
    private volatile HttpClient client = null;
    private final Transformer sendTransformer;

    public HttpClientMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (HttpConnector)endpoint.getConnector();
        List ts = this.connector.getDefaultOutboundTransformers();
        if (ts.size() == 1) {
            this.sendTransformer = (Transformer)ts.get(0);
        } else if (ts.size() == 0) {
            this.sendTransformer = new ObjectToHttpClientMethodRequest();
            this.sendTransformer.setMuleContext(this.connector.getMuleContext());
            this.sendTransformer.setEndpoint((ImmutableEndpoint)endpoint);
        } else {
            this.sendTransformer = new TransformerChain(ts);
        }
    }

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.sendTransformer.initialise();
    }

    protected void doConnect() throws Exception {
        if (this.client == null) {
            this.client = this.connector.doClientConnect();
        }
    }

    protected void doDisconnect() throws Exception {
        this.client = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(MuleEvent event) throws Exception {
        HttpMethod httpMethod = this.getMethod(event);
        this.connector.setupClientAuthorization(event, httpMethod, this.client, this.endpoint);
        try {
            this.execute(event, httpMethod);
            if (this.returnException(event, httpMethod)) {
                this.logger.error((Object)httpMethod.getResponseBodyAsString());
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)new Exception("Http call returned a status of: " + httpMethod.getStatusCode() + " " + httpMethod.getStatusText()));
            }
            if (httpMethod.getStatusCode() >= 300 && this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Received a redirect response code: " + httpMethod.getStatusCode() + " " + httpMethod.getStatusText()));
            }
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    protected HttpMethod execute(MuleEvent event, HttpMethod httpMethod) throws Exception {
        try {
            URI uri = event.getEndpoint().getEndpointURI().getUri();
            this.processCookies(event);
            this.client.executeMethod(this.getHostConfig(uri), httpMethod);
            return httpMethod;
        }
        catch (IOException e) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
        catch (Exception e) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    protected void processCookies(MuleEvent event) {
        MuleMessage msg = event.getMessage();
        Object cookiesProperty = msg.removeProperty("cookies");
        String cookieSpecProperty = (String)msg.removeProperty("cookieSpec");
        this.processCookies(cookiesProperty, cookieSpecProperty, event);
        cookiesProperty = this.endpoint.getProperty((Object)"cookies");
        cookieSpecProperty = (String)this.endpoint.getProperty((Object)"cookieSpec");
        this.processCookies(cookiesProperty, cookieSpecProperty, event);
    }

    private void processCookies(Object cookieObject, String policy, MuleEvent event) {
        if (cookieObject instanceof Cookie[]) {
            Cookie[] cookies = (Cookie[])cookieObject;
            if (cookies.length > 0) {
                this.client.getParams().setCookiePolicy(CookieHelper.getCookiePolicy(policy));
                for (Cookie cookie : cookies) {
                    cookie.setDomain(this.endpoint.getEndpointURI().getHost());
                    if (StringUtils.isNotBlank((String)this.endpoint.getEndpointURI().getPath())) {
                        cookie.setPath(this.endpoint.getEndpointURI().getPath());
                    }
                    cookie.setSecure(this.endpoint.getEndpointURI().getScheme().equalsIgnoreCase("https"));
                    this.client.getState().addCookie(cookie);
                }
            }
        } else if (cookieObject instanceof Map) {
            this.client.getParams().setCookiePolicy("rfc2109");
            String host = this.getEndpoint().getEndpointURI().getHost();
            String path = this.getEndpoint().getEndpointURI().getPath();
            Map cookieMap = (Map)cookieObject;
            for (String key : cookieMap.keySet()) {
                String cookieValue = (String)cookieMap.get(key);
                String value = event.getMuleContext().getExpressionManager().parse(cookieValue, event.getMessage());
                Cookie cookie = new Cookie(host, key, value, path, null, false);
                this.client.getState().addCookie(cookie);
            }
        } else if (cookieObject != null) {
            throw new IllegalArgumentException("Invalid cookies " + cookieObject);
        }
    }

    protected HttpMethod getMethod(MuleEvent event) throws TransformerException {
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(event.getTimeout());
        this.client.getHttpConnectionManager().getParams().setSoTimeout(event.getTimeout());
        MuleMessage msg = event.getMessage();
        this.setPropertyFromEndpoint(event, msg, "http.custom.headers");
        Object body = event.transformMessage();
        HttpMethod httpMethod = body instanceof HttpMethod ? (HttpMethod)body : (HttpMethod)this.sendTransformer.transform((Object)msg);
        httpMethod.setFollowRedirects("true".equalsIgnoreCase((String)this.endpoint.getProperty((Object)"followRedirects")));
        return httpMethod;
    }

    protected void setPropertyFromEndpoint(MuleEvent event, MuleMessage msg, String prop) {
        Object o = msg.getProperty(prop, PropertyScope.OUTBOUND);
        if (o == null && (o = event.getEndpoint().getProperty((Object)prop)) != null) {
            msg.setProperty(prop, o);
        }
    }

    protected HttpMethod createEntityMethod(MuleEvent event, Object body, EntityEnclosingMethod postMethod) throws TransformerException {
        HttpMethod httpMethod;
        if (body instanceof String) {
            httpMethod = (HttpMethod)this.sendTransformer.transform((Object)body.toString());
        } else if (body instanceof byte[]) {
            byte[] buffer = event.transformMessageToBytes();
            postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(buffer, event.getEncoding()));
            httpMethod = postMethod;
        } else {
            if (!(body instanceof OutputHandler)) {
                body = event.transformMessage(OutputHandler.class);
            }
            OutputHandler outputHandler = (OutputHandler)body;
            postMethod.setRequestEntity((RequestEntity)new StreamPayloadRequestEntity(outputHandler, event));
            postMethod.setContentChunked(true);
            httpMethod = postMethod;
        }
        return httpMethod;
    }

    /*
     * Loose catch block
     */
    protected MuleMessage doSend(MuleEvent event) throws Exception {
        HttpMethod httpMethod = this.getMethod(event);
        this.connector.setupClientAuthorization(event, httpMethod, this.client, this.endpoint);
        httpMethod.getParams().setParameter("http.method.retry-handler", (Object)new MuleHttpMethodRetryHandler());
        boolean releaseConn = false;
        try {
            httpMethod = this.execute(event, httpMethod);
            DefaultExceptionPayload ep = null;
            if (this.returnException(event, httpMethod)) {
                ep = new DefaultExceptionPayload((Throwable)new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)new HttpResponseException(httpMethod.getStatusText(), httpMethod.getStatusCode())));
            } else if (httpMethod.getStatusCode() >= 300) {
                try {
                    MuleMessage muleMessage = this.handleRedirect(httpMethod, event);
                    return muleMessage;
                }
                catch (Exception e) {
                    MuleMessage muleMessage;
                    block14: {
                        ep = new DefaultExceptionPayload((Throwable)new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e));
                        muleMessage = this.getResponseFromMethod(httpMethod, (ExceptionPayload)ep);
                        if (!releaseConn) break block14;
                        httpMethod.releaseConnection();
                    }
                    return muleMessage;
                }
            }
            releaseConn = httpMethod.getResponseBodyAsStream() == null;
            MuleMessage muleMessage = this.getResponseFromMethod(httpMethod, (ExceptionPayload)ep);
            return muleMessage;
            {
                catch (Exception e) {
                    releaseConn = true;
                    if (e instanceof DispatchException) {
                        throw (DispatchException)e;
                    }
                    throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (releaseConn) {
                httpMethod.releaseConnection();
            }
        }
    }

    protected MuleMessage handleRedirect(HttpMethod method, MuleEvent event) throws HttpResponseException, MuleException, IOException {
        String followRedirects = (String)this.endpoint.getProperty((Object)"followRedirects");
        if (followRedirects == null || "false".equalsIgnoreCase(followRedirects)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Received a redirect, but followRedirects=false. Response code: " + method.getStatusCode() + " " + method.getStatusText()));
            }
            return this.getResponseFromMethod(method, null);
        }
        Header locationHeader = method.getResponseHeader("Location");
        if (locationHeader == null) {
            throw new HttpResponseException(method.getStatusText(), method.getStatusCode());
        }
        OutboundEndpoint out = new EndpointURIEndpointBuilder(locationHeader.getValue(), this.connector.getMuleContext()).buildOutboundEndpoint();
        if (event.isSynchronous()) {
            return this.connector.send(out, event);
        }
        this.connector.dispatch(out, event);
        return null;
    }

    protected MuleMessage getResponseFromMethod(HttpMethod httpMethod, ExceptionPayload ep) throws IOException {
        Object body = null;
        Object is = httpMethod.getResponseBodyAsStream();
        if (is == null) {
            body = "";
        } else {
            is = new ReleasingInputStream((InputStream)is, httpMethod);
            body = is;
        }
        Header[] headers = httpMethod.getResponseHeaders();
        HttpMessageAdapter adapter = new HttpMessageAdapter(new Object[]{body, headers});
        String status = String.valueOf(httpMethod.getStatusCode());
        adapter.setProperty("http.status", status);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Http response is: " + status));
        }
        DefaultMuleMessage m = new DefaultMuleMessage((Object)adapter, this.connector.getMuleContext());
        m.setExceptionPayload(ep);
        return m;
    }

    protected boolean returnException(MuleEvent event, HttpMethod httpMethod) {
        return httpMethod.getStatusCode() >= 400 && !BooleanUtils.toBoolean((String)((String)event.getMessage().getProperty("http.disable.status.code.exception.check")));
    }

    protected HostConfiguration getHostConfig(URI uri) throws Exception {
        Protocol protocol = Protocol.getProtocol((String)uri.getScheme().toLowerCase());
        String host = uri.getHost();
        int port = uri.getPort();
        HostConfiguration config = new HostConfiguration();
        config.setHost(host, port, protocol);
        if (StringUtils.isNotBlank((String)this.connector.getProxyHostname())) {
            config.setProxy(this.connector.getProxyHostname(), this.connector.getProxyPort());
        }
        return config;
    }

    protected void doDispose() {
    }
}

