/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PGPZLibInputStreamAdapter
extends InputStream {
    private PGPPacketDataInputStream in;
    private boolean dummySent = false;

    public PGPZLibInputStreamAdapter(PGPPacketDataInputStream in) {
        this.in = in;
    }

    public int available() throws IOException {
        return 0;
    }

    private static final int byteToInt(byte b) {
        int i = 0;
        if ((b & 0x80) != 0) {
            i |= 0x80;
            b = (byte)(b & 0x7F);
        }
        return i |= b;
    }

    public void close() throws IOException {
    }

    public synchronized void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        try {
            int len = this.in.readBuffer(buf);
            if (len > 0) {
                return PGPZLibInputStreamAdapter.byteToInt(buf[0]);
            }
            if (this.dummySent) {
                return -1;
            }
            this.dummySent = true;
            return 0;
        }
        catch (PGPDataFormatException e) {
            throw new IOException("Data format exception: " + e.getMessage());
        }
        catch (PGPFatalDataFormatException e) {
            throw new IOException("Fatal data format exception: " + e.getMessage());
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            int r = this.in.readBuffer(b);
            if (r > 0) {
                return r;
            }
            if (this.dummySent) {
                return -1;
            }
            this.dummySent = true;
            return 1;
        }
        catch (PGPDataFormatException e) {
            throw new IOException("Data format exception: " + e.getMessage());
        }
        catch (PGPFatalDataFormatException e) {
            throw new IOException("Fatal data format exception: " + e.getMessage());
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int r = this.in.readBuffer(b, off, len);
            if (r > 0) {
                return r;
            }
            if (this.dummySent) {
                return -1;
            }
            this.dummySent = true;
            return 1;
        }
        catch (PGPDataFormatException e) {
            throw new IOException("Data format exception: " + e.getMessage());
        }
        catch (PGPFatalDataFormatException e) {
            throw new IOException("Fatal data format exception: " + e.getMessage());
        }
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

