/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPStringToKey;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import cryptix.openpgp.io.PGPPacketDataOutputStream;
import cryptix.openpgp.packet.PGPCryptHelper;
import cryptix.openpgp.packet.PGPSessionKey;
import cryptix.openpgp.packet.PGPSessionKeyPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;

public class PGPSymmetricKeyEncryptedSessionKeyPacket
extends PGPSessionKeyPacket {
    private byte version;
    private byte datacipher;
    private byte[] encrypted;
    private byte[] sessionkey;
    private boolean decrypted = false;

    public void decodeBody(PGPPacketDataInputStream in, PGPAlgorithmFactory factory) throws IOException, PGPFatalDataFormatException, PGPDataFormatException {
        this.version = in.readByte();
        if (this.version != 4) {
            in.readByteArray();
            throw new PGPDataFormatException("Unknown version for symmetrically encrypted session key packet.");
        }
        this.encrypted = in.readByteArray();
    }

    public void decrypt(String passphrase, PGPAlgorithmFactory factory) throws PGPDataFormatException {
        try {
            int blocksize;
            int size;
            MessageDigest md;
            PGPStringToKey s2k;
            ByteArrayInputStream bais = new ByteArrayInputStream(this.encrypted);
            DataInputStream dis = new DataInputStream(bais);
            byte cipherid = dis.readByte();
            byte s2kid = dis.readByte();
            byte hashid = dis.readByte();
            try {
                s2k = factory.getS2KAlgorithm(s2kid);
                md = factory.getHashAlgorithm(hashid);
                size = factory.getCipherKeySize(cipherid);
                blocksize = factory.getCipherBlockSize(cipherid);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new PGPDataFormatException(nsae.toString());
            }
            byte[] passbytes = passphrase.getBytes("UTF-8");
            byte[] key = s2k.readAndHash(passbytes, md, size, dis);
            if (dis.available() == 0) {
                this.sessionkey = key;
                this.datacipher = cipherid;
            } else {
                Cipher cp;
                byte[] iv = new byte[blocksize];
                int i = 0;
                while (i < iv.length) {
                    iv[i] = 0;
                    ++i;
                }
                byte[] data = new byte[dis.available()];
                dis.readFully(data);
                try {
                    cp = factory.getCipherAlgorithm(cipherid, "CFB");
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new PGPDataFormatException(nsae.toString());
                }
                byte[] result = PGPCryptHelper.crypt(false, cp, iv, key, data);
                this.datacipher = result[0];
                this.sessionkey = new byte[result.length - 1];
                System.arraycopy(result, 1, this.sessionkey, 0, this.sessionkey.length);
            }
            dis.close();
            bais.close();
            this.decrypted = true;
        }
        catch (IOException iOException) {
            throw new InternalError("IOException on bytearray");
        }
    }

    public void encodeBody(PGPPacketDataOutputStream out) throws IOException {
        if (this.encrypted == null) {
            throw new IllegalStateException("Session key not initialized or not encrypted yet.");
        }
        out.setLength(this.encrypted.length + 1);
        out.writeByte(this.version);
        out.writeFully(this.encrypted);
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPSymmetricKeyEncryptedSessionKeyPacket)) {
            return false;
        }
        PGPSymmetricKeyEncryptedSessionKeyPacket that = (PGPSymmetricKeyEncryptedSessionKeyPacket)ssp;
        return this.version == that.version && this.datacipher == that.datacipher && PGPCompare.equals(this.encrypted, that.encrypted) && PGPCompare.equals(this.sessionkey, that.sessionkey);
    }

    public PGPSessionKey getSessionKey() {
        if (this.decrypted) {
            return new PGPSessionKey(this.sessionkey, this.datacipher);
        }
        throw new IllegalStateException("Data not decrypted yet.");
    }

    public void setDirect(String passphrase, PGPAlgorithmFactory factory, SecureRandom sr, byte datacipherid, byte s2kid, byte hashid) {
        try {
            int size;
            MessageDigest md;
            PGPStringToKey s2k;
            this.version = (byte)4;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeByte(datacipherid);
            dos.writeByte(s2kid);
            dos.writeByte(hashid);
            try {
                s2k = factory.getS2KAlgorithm(s2kid);
                md = factory.getHashAlgorithm(hashid);
                size = factory.getCipherKeySize(datacipherid);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new IllegalArgumentException("id not found - " + nsae);
            }
            byte[] passbytes = passphrase.getBytes("UTF-8");
            this.sessionkey = s2k.generateAndHash(passbytes, md, size, dos, sr);
            dos.close();
            baos.close();
            this.encrypted = baos.toByteArray();
        }
        catch (IOException iOException) {
            throw new InternalError("IOException on bytearray");
        }
    }

    public void setEncrypted(byte[] sessionkey, String passphrase, PGPAlgorithmFactory factory, SecureRandom sr, byte datacipherid, byte keycipherid, byte s2kid, byte hashid) {
        try {
            int blocksize;
            int keyciphersize;
            int dataciphersize;
            Cipher cp;
            MessageDigest md;
            PGPStringToKey s2k;
            this.version = (byte)4;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeByte(keycipherid);
            dos.writeByte(s2kid);
            dos.writeByte(hashid);
            try {
                s2k = factory.getS2KAlgorithm(s2kid);
                md = factory.getHashAlgorithm(hashid);
                cp = factory.getCipherAlgorithm(keycipherid, "CFB");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new IllegalArgumentException("id not found - " + nsae);
            }
            if (!s2k.isSalted()) {
                throw new IllegalArgumentException("Chosen S2K algorithm is not salted.");
            }
            try {
                dataciphersize = factory.getCipherKeySize(datacipherid);
                keyciphersize = factory.getCipherKeySize(keycipherid);
                blocksize = factory.getCipherBlockSize(keycipherid);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new IllegalArgumentException("id not found - " + nsae);
            }
            byte[] passbytes = passphrase.getBytes("UTF-8");
            byte[] encryptkey = s2k.generateAndHash(passbytes, md, keyciphersize, dos, sr);
            byte[] iv = new byte[blocksize];
            int i = 0;
            while (i < iv.length) {
                iv[i] = 0;
                ++i;
            }
            sessionkey = new byte[dataciphersize];
            sr.nextBytes(sessionkey);
            byte[] data = new byte[sessionkey.length + 1];
            data[0] = datacipherid;
            System.arraycopy(sessionkey, 0, data, 1, sessionkey.length);
            byte[] crypted = PGPCryptHelper.crypt(true, cp, iv, encryptkey, data);
            dos.write(crypted);
            dos.close();
            baos.close();
            this.encrypted = baos.toByteArray();
        }
        catch (IOException iOException) {
            throw new InternalError("IOException on bytearray");
        }
    }
}

